/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdConstants;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestArgs;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestFrame;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestHeaders;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdToken;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.guava27.Strings;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.netty.buffer.ByteBuf;
import java.util.UUID;

public final class RntbdRequest {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final RntbdRequestFrame frame;
    private final RntbdRequestHeaders headers;
    private final byte[] payload;

    private RntbdRequest(RntbdRequestFrame frame, RntbdRequestHeaders headers, byte[] payload) {
        Preconditions.checkNotNull(frame, "frame");
        Preconditions.checkNotNull(headers, "headers");
        this.frame = frame;
        this.headers = headers;
        this.payload = payload == null ? EMPTY_BYTE_ARRAY : payload;
    }

    public UUID getActivityId() {
        return this.frame.getActivityId();
    }

    @JsonIgnore
    public <T> T getHeader(RntbdConstants.RntbdRequestHeader header) {
        return (T)this.headers.get(header).getValue();
    }

    @JsonIgnore
    public boolean setHeaderValue(RntbdConstants.RntbdRequestHeader header, Object value) {
        RntbdToken token = this.headers.get(header);
        if (token == null) {
            return false;
        }
        token.setValue(value);
        return true;
    }

    public Long getTransportRequestId() {
        return (Long)this.getHeader(RntbdConstants.RntbdRequestHeader.TransportRequestID);
    }

    public static RntbdRequest decode(ByteBuf in) {
        int resourceOperationCode = in.getInt(in.readerIndex() + 4);
        if (resourceOperationCode == 0) {
            String reason = String.format("resourceOperationCode=0x%08X", resourceOperationCode);
            throw new IllegalStateException(reason);
        }
        int start = in.readerIndex();
        int expectedLength = in.readIntLE();
        RntbdRequestFrame header = RntbdRequestFrame.decode(in);
        RntbdRequestHeaders metadata = RntbdRequestHeaders.decode(in);
        ByteBuf payloadBuf = in.readSlice(expectedLength - (in.readerIndex() - start));
        int observedLength = in.readerIndex() - start;
        if (observedLength != expectedLength) {
            String reason = Strings.lenientFormat("expectedLength=%s, observedLength=%s", expectedLength, observedLength);
            throw new IllegalStateException(reason);
        }
        byte[] payload = new byte[payloadBuf.readableBytes()];
        payloadBuf.readBytes(payload);
        in.discardReadBytes();
        return new RntbdRequest(header, metadata, payload);
    }

    public void encode(ByteBuf out, boolean forThinClient) {
        int effectivePayloadSize = this.payload != null && this.payload.length > 0 ? this.payload.length + 4 : 0;
        int expectedLength = 24 + this.headers.computeLength(forThinClient);
        int start = out.writerIndex();
        out.writeIntLE(expectedLength);
        this.frame.encode(out);
        this.headers.encode(out, forThinClient);
        int observedLength = out.writerIndex() - start;
        Preconditions.checkState(observedLength == expectedLength, "encoding error: {\"expectedLength\": %s, \"observedLength\": %s}", expectedLength, observedLength);
        if (this.payload.length > 0) {
            out.writeIntLE(this.payload.length);
            out.writeBytes(this.payload);
            observedLength = out.writerIndex() - start;
            Preconditions.checkState(observedLength == expectedLength + effectivePayloadSize, "payload encoding error: {\"expectedLength\": %s, \"observedLength\": %s}", expectedLength + effectivePayloadSize, observedLength);
        }
    }

    public static RntbdRequest from(RntbdRequestArgs args) {
        RxDocumentServiceRequest serviceRequest = args.serviceRequest();
        RntbdRequestFrame frame = new RntbdRequestFrame(args.activityId(), serviceRequest.getOperationType(), serviceRequest.getResourceType());
        RntbdRequestHeaders headers = new RntbdRequestHeaders(args, frame);
        return new RntbdRequest(frame, headers, serviceRequest.getContentAsByteArray());
    }
}

