/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.common;

import com.azure.cosmos.implementation.changefeed.ChangeFeedObserver;
import com.azure.cosmos.implementation.changefeed.ChangeFeedObserverFactory;
import com.azure.cosmos.implementation.changefeed.CheckpointFrequency;
import com.azure.cosmos.implementation.changefeed.common.AutoCheckpointer;
import com.azure.cosmos.implementation.changefeed.common.ObserverExceptionWrappingChangeFeedObserverDecorator;

public class CheckpointerObserverFactory<T>
implements ChangeFeedObserverFactory<T> {
    private final ChangeFeedObserverFactory<T> observerFactory;
    private final CheckpointFrequency checkpointFrequency;

    public CheckpointerObserverFactory(ChangeFeedObserverFactory<T> observerFactory, CheckpointFrequency checkpointFrequency) {
        if (observerFactory == null) {
            throw new IllegalArgumentException("observerFactory");
        }
        if (checkpointFrequency == null) {
            throw new IllegalArgumentException("checkpointFrequency");
        }
        this.observerFactory = observerFactory;
        this.checkpointFrequency = checkpointFrequency;
    }

    @Override
    public ChangeFeedObserver<T> createObserver() {
        ObserverExceptionWrappingChangeFeedObserverDecorator<T> observer = new ObserverExceptionWrappingChangeFeedObserverDecorator<T>(this.observerFactory.createObserver());
        if (this.checkpointFrequency.isExplicitCheckpoint()) {
            return observer;
        }
        return new AutoCheckpointer<T>(this.checkpointFrequency, observer);
    }
}

