/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.common;

import com.azure.cosmos.implementation.changefeed.ChangeFeedObserverContext;
import com.azure.cosmos.implementation.changefeed.Lease;
import com.azure.cosmos.implementation.changefeed.PartitionCheckpointer;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedState;
import com.azure.cosmos.models.FeedResponse;
import reactor.core.publisher.Mono;

public class ChangeFeedObserverContextImpl<T>
implements ChangeFeedObserverContext<T> {
    private final PartitionCheckpointer checkpointer;
    private final String leaseToken;
    private final FeedResponse<T> feedResponse;
    private final ChangeFeedState continuationState;

    public ChangeFeedObserverContextImpl(String leaseToken) {
        this.leaseToken = leaseToken;
        this.checkpointer = null;
        this.feedResponse = null;
        this.continuationState = null;
    }

    public ChangeFeedObserverContextImpl(String leaseToken, FeedResponse<T> feedResponse, ChangeFeedState continuationState, PartitionCheckpointer checkpointer) {
        this.leaseToken = leaseToken;
        this.feedResponse = feedResponse;
        this.checkpointer = checkpointer;
        this.continuationState = continuationState;
    }

    @Override
    public Mono<Lease> checkpoint() {
        return this.checkpointer.checkpointPartition(this.continuationState);
    }

    @Override
    public String getLeaseToken() {
        return this.leaseToken;
    }

    @Override
    public FeedResponse<T> getFeedResponse() {
        return this.feedResponse;
    }
}

