/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.BadRequestException;
import com.azure.cosmos.implementation.DefaultCosmosItemSerializer;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.Utils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;

public abstract class CosmosItemSerializer {
    public static final CosmosItemSerializer DEFAULT_SERIALIZER = DefaultCosmosItemSerializer.DEFAULT_SERIALIZER;
    private boolean shouldWrapSerializationExceptions = true;
    private ObjectMapper mapper = Utils.getSimpleObjectMapper();

    protected CosmosItemSerializer() {
    }

    public abstract <T> Map<String, Object> serialize(T var1);

    <T> Map<String, Object> serializeSafe(T item) {
        try {
            return this.serialize(item);
        }
        catch (Throwable throwable) {
            if (!this.shouldWrapSerializationExceptions) {
                throw throwable;
            }
            Exception inner = throwable instanceof Exception ? (Exception)throwable : new RuntimeException(throwable);
            BadRequestException exception = new BadRequestException("Custom serializer '" + this.getClass().getSimpleName() + "' failed to serialize item.", inner);
            BridgeInternal.setSubStatusCode(exception, 10101);
            throw exception;
        }
    }

    ObjectMapper getItemObjectMapper() {
        return this.mapper;
    }

    void setItemObjectMapper(ObjectMapper newMapper) {
        this.mapper = newMapper;
    }

    public abstract <T> T deserialize(Map<String, Object> var1, Class<T> var2);

    <T> T deserializeSafe(Map<String, Object> jsonNodeMap, Class<T> classType) {
        try {
            return this.deserialize(jsonNodeMap, classType);
        }
        catch (Throwable throwable) {
            if (!this.shouldWrapSerializationExceptions) {
                throw throwable;
            }
            Exception inner = throwable instanceof Exception ? (Exception)throwable : new RuntimeException(throwable);
            BadRequestException exception = new BadRequestException("Custom serializer '" + this.getClass().getSimpleName() + "' failed to deserialize item.", inner);
            BridgeInternal.setSubStatusCode(exception, 10101);
            throw exception;
        }
    }

    void setShouldWrapSerializationExceptions(boolean enabled) {
        this.shouldWrapSerializationExceptions = enabled;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosItemSerializerHelper.setCosmosItemSerializerAccessor(new ImplementationBridgeHelpers.CosmosItemSerializerHelper.CosmosItemSerializerAccessor(){

            @Override
            public <T> Map<String, Object> serializeSafe(CosmosItemSerializer serializer, T item) {
                return serializer.serializeSafe(item);
            }

            @Override
            public <T> T deserializeSafe(CosmosItemSerializer serializer, Map<String, Object> jsonNodeMap, Class<T> classType) {
                return serializer.deserializeSafe(jsonNodeMap, classType);
            }

            @Override
            public void setShouldWrapSerializationExceptions(CosmosItemSerializer serializer, boolean shouldWrapSerializationExceptions) {
                serializer.setShouldWrapSerializationExceptions(shouldWrapSerializationExceptions);
            }

            @Override
            public void setItemObjectMapper(CosmosItemSerializer serializer, ObjectMapper mapper) {
                serializer.setItemObjectMapper(mapper);
            }

            @Override
            public ObjectMapper getItemObjectMapper(CosmosItemSerializer serializer) {
                return serializer.getItemObjectMapper();
            }
        });
    }

    static {
        CosmosItemSerializer.initialize();
    }
}

