/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.uuid.impl;

import com.azure.cosmos.implementation.uuid.EthernetAddress;
import com.azure.cosmos.implementation.uuid.NoArgGenerator;
import com.azure.cosmos.implementation.uuid.UUIDTimer;
import com.azure.cosmos.implementation.uuid.UUIDType;
import com.azure.cosmos.implementation.uuid.impl.UUIDUtil;
import java.util.UUID;

public class TimeBasedGenerator
extends NoArgGenerator {
    protected final EthernetAddress _ethernetAddress;
    protected final UUIDTimer _timer;
    protected final long _uuidL2;

    public TimeBasedGenerator(EthernetAddress ethAddr, UUIDTimer timer) {
        byte[] uuidBytes = new byte[16];
        if (ethAddr == null) {
            ethAddr = EthernetAddress.constructMulticastAddress();
        }
        this._ethernetAddress = ethAddr;
        this._ethernetAddress.toByteArray(uuidBytes, 10);
        int clockSeq = timer.getClockSequence();
        uuidBytes[8] = (byte)(clockSeq >> 8);
        uuidBytes[9] = (byte)clockSeq;
        long l2 = UUIDUtil.gatherLong(uuidBytes, 8);
        this._uuidL2 = UUIDUtil.initUUIDSecondLong(l2);
        this._timer = timer;
    }

    @Override
    public UUIDType getType() {
        return UUIDType.TIME_BASED;
    }

    public EthernetAddress getEthernetAddress() {
        return this._ethernetAddress;
    }

    @Override
    public UUID generate() {
        long rawTimestamp = this._timer.getTimestamp();
        int clockHi = (int)(rawTimestamp >>> 32);
        int clockLo = (int)rawTimestamp;
        int midhi = clockHi << 16 | clockHi >>> 16;
        midhi &= 0xFFFF0FFF;
        long midhiL = midhi |= 0x1000;
        midhiL = midhiL << 32 >>> 32;
        long l1 = (long)clockLo << 32 | midhiL;
        return new UUID(l1, this._uuidL2);
    }
}

