/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.BadRequestException;
import com.azure.cosmos.implementation.ClientSideRequestStatistics;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.query.GroupingTable;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.PipelinedDocumentQueryParams;
import com.azure.cosmos.implementation.query.aggregation.AggregateOperator;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class GroupByDocumentQueryExecutionContext
implements IDocumentQueryExecutionComponent<Document> {
    public static final String CONTINUATION_TOKEN_NOT_SUPPORTED_WITH_GROUP_BY = "Continuation token is not supported for queries with GROUP BY.Do not use continuation token or remove the GROUP BY from the query.";
    private final IDocumentQueryExecutionComponent<Document> component;
    private final GroupingTable groupingTable;

    GroupByDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<Document> component, GroupingTable groupingTable) {
        this.component = component;
        this.groupingTable = groupingTable;
    }

    public static Flux<IDocumentQueryExecutionComponent<Document>> createAsync(BiFunction<String, PipelinedDocumentQueryParams<Document>, Flux<IDocumentQueryExecutionComponent<Document>>> createSourceComponentFunction, String continuationToken, Map<String, AggregateOperator> groupByAliasToAggregateType, List<String> orderedAliases, boolean hasSelectValue, PipelinedDocumentQueryParams<Document> documentQueryParams) {
        if (continuationToken != null) {
            BadRequestException dce = new BadRequestException(CONTINUATION_TOKEN_NOT_SUPPORTED_WITH_GROUP_BY);
            return Flux.error((Throwable)((Object)dce));
        }
        if (groupByAliasToAggregateType == null) {
            throw new IllegalArgumentException("groupByAliasToAggregateType should not be null");
        }
        if (orderedAliases == null) {
            throw new IllegalArgumentException("orderedAliases should not be null");
        }
        GroupingTable table = new GroupingTable(groupByAliasToAggregateType, orderedAliases, hasSelectValue);
        return createSourceComponentFunction.apply(null, documentQueryParams).map(component -> new GroupByDocumentQueryExecutionContext((IDocumentQueryExecutionComponent<Document>)component, table));
    }

    @Override
    public Flux<FeedResponse<Document>> drainAsync(int maxPageSize) {
        return this.component.drainAsync(maxPageSize).collectList().map(superList -> {
            double requestCharge = 0.0;
            ArrayList<Document> documentList = new ArrayList<Document>();
            ArrayList<ClientSideRequestStatistics> diagnosticsList = new ArrayList<ClientSideRequestStatistics>();
            ConcurrentHashMap<String, QueryMetrics> queryMetrics = new ConcurrentHashMap<String, QueryMetrics>();
            for (FeedResponse page : superList) {
                List results = page.getResults();
                documentList.addAll(results);
                requestCharge += page.getRequestCharge();
                QueryMetrics.mergeQueryMetricsMap(queryMetrics, BridgeInternal.queryMetricsFromFeedResponse(page));
                diagnosticsList.addAll(BridgeInternal.getClientSideRequestStatisticsList(page.getCosmosDiagnostics()));
            }
            this.aggregateGroupings(documentList);
            List<Document> groupByResults = null;
            if (this.groupingTable != null) {
                groupByResults = this.groupingTable.drain(maxPageSize);
            }
            return this.createFeedResponseFromGroupingTable(requestCharge, queryMetrics, groupByResults, diagnosticsList);
        }).expand(tFeedResponse -> {
            List<Document> groupByResults = null;
            if (this.groupingTable != null) {
                groupByResults = this.groupingTable.drain(maxPageSize);
            }
            if (groupByResults == null || groupByResults.size() == 0) {
                return Mono.empty();
            }
            FeedResponse<Document> response = this.createFeedResponseFromGroupingTable(0.0, new ConcurrentHashMap<String, QueryMetrics>(), groupByResults, new ArrayList<ClientSideRequestStatistics>());
            return Mono.just(response);
        });
    }

    private FeedResponse<Document> createFeedResponseFromGroupingTable(double requestCharge, ConcurrentMap<String, QueryMetrics> queryMetrics, List<Document> groupByResults, List<ClientSideRequestStatistics> diagnosticsList) {
        if (this.groupingTable == null) {
            throw new IllegalStateException("No grouping table defined.");
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-ms-request-charge", Double.toString(requestCharge));
        FeedResponse<Document> frp = BridgeInternal.createFeedResponseWithQueryMetrics(groupByResults, headers, queryMetrics, null, false, false, null);
        BridgeInternal.addClientSideDiagnosticsToFeed(frp.getCosmosDiagnostics(), diagnosticsList);
        return frp;
    }

    private void aggregateGroupings(List<Document> superList) {
        for (Document d : superList) {
            RewrittenGroupByProjection rewrittenGroupByProjection = new RewrittenGroupByProjection(ModelBridgeInternal.getPropertyBagFromJsonSerializable(d));
            this.groupingTable.addPayLoad(rewrittenGroupByProjection);
        }
    }

    static final class RewrittenGroupByProjection
    extends JsonSerializable {
        private static final String GROUP_BY_ITEMS_PROPERTY_NAME = "groupByItems";
        private static final String PAYLOAD_PROPERTY_NAME = "payload";

        public RewrittenGroupByProjection(ObjectNode objectNode) {
            super(objectNode);
            if (objectNode == null) {
                throw new IllegalArgumentException("objectNode can not be null");
            }
        }

        public List<Document> getGroupByItems() {
            List<Document> groupByItems = this.getList(GROUP_BY_ITEMS_PROPERTY_NAME, Document.class, new boolean[0]);
            if (groupByItems == null) {
                throw new IllegalStateException("Underlying object does not have an 'groupByItems' field.");
            }
            return groupByItems;
        }

        public Document getPayload() {
            if (!this.has(PAYLOAD_PROPERTY_NAME)) {
                throw new IllegalStateException("Underlying object does not have an 'payload' field.");
            }
            return new Document((ObjectNode)this.get(PAYLOAD_PROPERTY_NAME));
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

