/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.ClientSideRequestStatistics;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.PipelinedDocumentQueryParams;
import com.azure.cosmos.implementation.query.SingleGroupAggregator;
import com.azure.cosmos.implementation.query.aggregation.AggregateOperator;
import com.azure.cosmos.models.FeedResponse;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import reactor.core.publisher.Flux;

public class AggregateDocumentQueryExecutionContext
implements IDocumentQueryExecutionComponent<Document> {
    public static final String PAYLOAD_PROPERTY_NAME = "payload";
    private final boolean isValueAggregateQuery;
    private final IDocumentQueryExecutionComponent<Document> component;
    private final ConcurrentMap<String, QueryMetrics> queryMetricsMap = new ConcurrentHashMap<String, QueryMetrics>();
    private final SingleGroupAggregator singleGroupAggregator;

    public AggregateDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<Document> component, List<AggregateOperator> aggregateOperators, Map<String, AggregateOperator> groupByAliasToAggregateType, List<String> orderedAliases, boolean hasSelectValue, String continuationToken) {
        this.component = component;
        this.isValueAggregateQuery = hasSelectValue;
        this.singleGroupAggregator = SingleGroupAggregator.create(aggregateOperators, groupByAliasToAggregateType, orderedAliases, hasSelectValue, continuationToken);
    }

    @Override
    public Flux<FeedResponse<Document>> drainAsync(int maxPageSize) {
        return this.component.drainAsync(maxPageSize).collectList().map(superList -> {
            double requestCharge = 0.0;
            ArrayList<Document> aggregateResults = new ArrayList<Document>();
            HashMap<String, String> headers = new HashMap<String, String>();
            ArrayList<ClientSideRequestStatistics> diagnosticsList = new ArrayList<ClientSideRequestStatistics>();
            for (FeedResponse page : superList) {
                diagnosticsList.addAll(BridgeInternal.getClientSideRequestStatisticsList(page.getCosmosDiagnostics()));
                if (page.getResults().size() == 0) {
                    headers.put("x-ms-request-charge", Double.toString(requestCharge));
                    FeedResponse frp = BridgeInternal.createFeedResponse(aggregateResults, headers);
                    BridgeInternal.addClientSideDiagnosticsToFeed(frp.getCosmosDiagnostics(), diagnosticsList);
                    return frp;
                }
                requestCharge += page.getRequestCharge();
                for (Document document : page.getResults()) {
                    RewrittenAggregateProjections rewrittenAggregateProjections = new RewrittenAggregateProjections(this.isValueAggregateQuery, document);
                    this.singleGroupAggregator.addValues(rewrittenAggregateProjections.getPayload());
                }
                for (String string : BridgeInternal.queryMetricsFromFeedResponse(page).keySet()) {
                    if (this.queryMetricsMap.containsKey(string)) {
                        QueryMetrics qm = (QueryMetrics)BridgeInternal.queryMetricsFromFeedResponse(page).get(string);
                        ((QueryMetrics)this.queryMetricsMap.get(string)).add(qm);
                        continue;
                    }
                    this.queryMetricsMap.put(string, (QueryMetrics)BridgeInternal.queryMetricsFromFeedResponse(page).get(string));
                }
            }
            Document aggregateDocument = this.singleGroupAggregator.getResult();
            if (aggregateDocument != null) {
                aggregateResults.add(aggregateDocument);
            }
            headers.put("x-ms-request-charge", Double.toString(requestCharge));
            FeedResponse frp = BridgeInternal.createFeedResponse(aggregateResults, headers);
            if (!this.queryMetricsMap.isEmpty()) {
                for (Map.Entry entry : this.queryMetricsMap.entrySet()) {
                    BridgeInternal.putQueryMetricsIntoMap(frp, (String)entry.getKey(), (QueryMetrics)entry.getValue());
                }
            }
            BridgeInternal.addClientSideDiagnosticsToFeed(frp.getCosmosDiagnostics(), diagnosticsList);
            return frp;
        }).flux();
    }

    public static Flux<IDocumentQueryExecutionComponent<Document>> createAsync(BiFunction<String, PipelinedDocumentQueryParams<Document>, Flux<IDocumentQueryExecutionComponent<Document>>> createSourceComponentFunction, Collection<AggregateOperator> aggregates, Map<String, AggregateOperator> groupByAliasToAggregateType, List<String> groupByAliases, boolean hasSelectValue, String continuationToken, PipelinedDocumentQueryParams<Document> documentQueryParams) {
        return createSourceComponentFunction.apply(continuationToken, documentQueryParams).map(component -> new AggregateDocumentQueryExecutionContext((IDocumentQueryExecutionComponent<Document>)component, (List<AggregateOperator>)new ArrayList<AggregateOperator>(aggregates), groupByAliasToAggregateType, groupByAliases, hasSelectValue, continuationToken));
    }

    public IDocumentQueryExecutionComponent<Document> getComponent() {
        return this.component;
    }

    static final class RewrittenAggregateProjections {
        private Document payload;

        public RewrittenAggregateProjections(boolean isValueAggregateQuery, Document document) {
            if (document == null) {
                throw new IllegalArgumentException("document cannot be null");
            }
            if (isValueAggregateQuery) {
                this.payload = new Document(document.getPropertyBag());
            } else {
                if (!document.has(AggregateDocumentQueryExecutionContext.PAYLOAD_PROPERTY_NAME)) {
                    throw new IllegalStateException("Underlying object does not have an 'payload' field.");
                }
                if (document.get(AggregateDocumentQueryExecutionContext.PAYLOAD_PROPERTY_NAME) instanceof ObjectNode) {
                    this.payload = new Document((ObjectNode)document.get(AggregateDocumentQueryExecutionContext.PAYLOAD_PROPERTY_NAME));
                }
            }
        }

        public Document getPayload() {
            return this.payload;
        }
    }
}

