/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdContextDecoder;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdContextRequest;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdContextRequestEncoder;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestManager;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RntbdContextNegotiator
extends CombinedChannelDuplexHandler<RntbdContextDecoder, RntbdContextRequestEncoder> {
    private static final Logger logger = LoggerFactory.getLogger(RntbdContextNegotiator.class);
    private final RntbdRequestManager manager;
    private final UserAgentContainer userAgent;
    private volatile boolean pendingRntbdContextRequest = true;

    public RntbdContextNegotiator(RntbdRequestManager manager, UserAgentContainer userAgent) {
        super((ChannelInboundHandler)new RntbdContextDecoder(), (ChannelOutboundHandler)new RntbdContextRequestEncoder());
        Preconditions.checkNotNull(manager, "manager");
        Preconditions.checkNotNull(userAgent, "userAgent");
        this.manager = manager;
        this.userAgent = userAgent;
    }

    public void write(ChannelHandlerContext context, Object message, ChannelPromise promise) throws Exception {
        Preconditions.checkArgument(message instanceof ByteBuf, "message: %s", message.getClass());
        ByteBuf out = (ByteBuf)message;
        if (this.manager.hasRntbdContext()) {
            context.writeAndFlush((Object)out, promise);
        } else {
            if (this.pendingRntbdContextRequest) {
                this.startRntbdContextRequest(context);
                this.pendingRntbdContextRequest = false;
            }
            this.manager.pendWrite(out, promise);
        }
    }

    private void startRntbdContextRequest(ChannelHandlerContext context) throws Exception {
        logger.debug("{} START CONTEXT REQUEST", (Object)context.channel());
        Channel channel = context.channel();
        RntbdContextRequest request = new RntbdContextRequest(Utils.randomUUID(), this.userAgent);
        CompletableFuture<RntbdContextRequest> contextRequestFuture = this.manager.rntbdContextRequestFuture();
        super.write(context, (Object)request, channel.newPromise().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                contextRequestFuture.complete(request);
                return;
            }
            if (future.isCancelled()) {
                contextRequestFuture.cancel(true);
                return;
            }
            contextRequestFuture.completeExceptionally(future.cause());
        })));
    }
}

