/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdContext;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdHealthCheckRequest;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdReporter;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestManager;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RntbdClientChannelHealthChecker
implements ChannelHealthChecker {
    private static final Logger logger = LoggerFactory.getLogger(RntbdClientChannelHealthChecker.class);
    private static final long recentReadWindowInNanos = 1000000000L;
    private static final long readHangGracePeriodInNanos = 55000000000L;
    private static final long writeHangGracePeriodInNanos = 2000000000L;
    @JsonProperty
    private final long idleConnectionTimeoutInNanos;
    @JsonProperty
    private final long readDelayLimitInNanos;
    @JsonProperty
    private final long writeDelayLimitInNanos;

    public RntbdClientChannelHealthChecker(RntbdEndpoint.Config config) {
        Preconditions.checkNotNull(config, "expected non-null config");
        Preconditions.checkArgument(config.receiveHangDetectionTimeInNanos() > 55000000000L, "config.receiveHangDetectionTimeInNanos: %s", config.receiveHangDetectionTimeInNanos());
        Preconditions.checkArgument(config.sendHangDetectionTimeInNanos() > 2000000000L, "config.sendHangDetectionTimeInNanos: %s", config.sendHangDetectionTimeInNanos());
        this.idleConnectionTimeoutInNanos = config.idleConnectionTimeoutInNanos();
        this.readDelayLimitInNanos = config.receiveHangDetectionTimeInNanos();
        this.writeDelayLimitInNanos = config.sendHangDetectionTimeInNanos();
    }

    public long idleConnectionTimeoutInNanos() {
        return this.idleConnectionTimeoutInNanos;
    }

    public long readDelayLimitInNanos() {
        return this.readDelayLimitInNanos;
    }

    public long writeDelayLimitInNanos() {
        return this.writeDelayLimitInNanos;
    }

    public Future<Boolean> isHealthy(Channel channel) {
        Preconditions.checkNotNull(channel, "expected non-null channel");
        RntbdRequestManager requestManager = (RntbdRequestManager)channel.pipeline().get(RntbdRequestManager.class);
        Promise promise = channel.eventLoop().newPromise();
        if (requestManager == null) {
            RntbdReporter.reportIssueUnless(logger, !channel.isActive(), channel, "active with no request manager", new Object[0]);
            return promise.setSuccess((Object)Boolean.FALSE);
        }
        Timestamps timestamps = requestManager.snapshotTimestamps();
        long currentTime = System.nanoTime();
        if (currentTime - timestamps.lastChannelReadNanoTime() < 1000000000L) {
            return promise.setSuccess((Object)Boolean.TRUE);
        }
        long writeDelayInNanos = timestamps.lastChannelWriteAttemptNanoTime() - timestamps.lastChannelWriteNanoTime();
        long writeHangDurationInNanos = currentTime - timestamps.lastChannelWriteAttemptNanoTime();
        if (writeDelayInNanos > this.writeDelayLimitInNanos && writeHangDurationInNanos > 2000000000L) {
            Optional<RntbdContext> rntbdContext = requestManager.rntbdContext();
            int pendingRequestCount = requestManager.pendingRequestCount();
            logger.warn("{} health check failed due to nonresponding write: {lastChannelWriteAttemptNanoTime: {}, lastChannelWriteNanoTime: {}, writeDelayInNanos: {}, writeDelayLimitInNanos: {}, rntbdContext: {}, pendingRequestCount: {}}", new Object[]{channel, timestamps.lastChannelWriteAttemptNanoTime(), timestamps.lastChannelWriteNanoTime(), writeDelayInNanos, this.writeDelayLimitInNanos, rntbdContext, pendingRequestCount});
            return promise.setSuccess((Object)Boolean.FALSE);
        }
        long readDelay = timestamps.lastChannelWriteNanoTime() - timestamps.lastChannelReadNanoTime();
        long readHangDuration = currentTime - timestamps.lastChannelWriteNanoTime();
        if (readDelay > this.readDelayLimitInNanos && readHangDuration > 55000000000L) {
            Optional<RntbdContext> rntbdContext = requestManager.rntbdContext();
            int pendingRequestCount = requestManager.pendingRequestCount();
            logger.warn("{} health check failed due to nonresponding read: {lastChannelWrite: {}, lastChannelRead: {}, readDelay: {}, readDelayLimit: {}, rntbdContext: {}, pendingRequestCount: {}}", new Object[]{channel, timestamps.lastChannelWriteNanoTime(), timestamps.lastChannelReadNanoTime(), readDelay, this.readDelayLimitInNanos, rntbdContext, pendingRequestCount});
            return promise.setSuccess((Object)Boolean.FALSE);
        }
        if (this.idleConnectionTimeoutInNanos > 0L && currentTime - timestamps.lastChannelReadNanoTime() > this.idleConnectionTimeoutInNanos) {
            return promise.setSuccess((Object)Boolean.FALSE);
        }
        channel.writeAndFlush((Object)RntbdHealthCheckRequest.MESSAGE).addListener(completed -> {
            if (completed.isSuccess()) {
                promise.setSuccess((Object)Boolean.TRUE);
            } else {
                logger.warn("{} health check request failed due to:", (Object)channel, (Object)completed.cause());
                promise.setSuccess((Object)Boolean.FALSE);
            }
        });
        return promise;
    }

    public String toString() {
        return RntbdObjectMapper.toString(this);
    }

    static final class Timestamps {
        private static final AtomicLongFieldUpdater<Timestamps> lastPingUpdater = AtomicLongFieldUpdater.newUpdater(Timestamps.class, "lastPingNanoTime");
        private static final AtomicLongFieldUpdater<Timestamps> lastReadUpdater = AtomicLongFieldUpdater.newUpdater(Timestamps.class, "lastReadNanoTime");
        private static final AtomicLongFieldUpdater<Timestamps> lastWriteUpdater = AtomicLongFieldUpdater.newUpdater(Timestamps.class, "lastWriteNanoTime");
        private static final AtomicLongFieldUpdater<Timestamps> lastWriteAttemptUpdater = AtomicLongFieldUpdater.newUpdater(Timestamps.class, "lastWriteAttemptNanoTime");
        private volatile long lastPingNanoTime;
        private volatile long lastReadNanoTime;
        private volatile long lastWriteNanoTime;
        private volatile long lastWriteAttemptNanoTime;

        public Timestamps() {
        }

        public Timestamps(Timestamps other) {
            Preconditions.checkNotNull(other, "other: null");
            this.lastPingNanoTime = lastPingUpdater.get(other);
            this.lastReadNanoTime = lastReadUpdater.get(other);
            this.lastWriteNanoTime = lastWriteUpdater.get(other);
            this.lastWriteAttemptNanoTime = lastWriteAttemptUpdater.get(other);
        }

        public void channelPingCompleted() {
            lastPingUpdater.set(this, System.nanoTime());
        }

        public void channelReadCompleted() {
            lastReadUpdater.set(this, System.nanoTime());
        }

        public void channelWriteAttempted() {
            lastWriteUpdater.set(this, System.nanoTime());
        }

        public void channelWriteCompleted() {
            lastWriteAttemptUpdater.set(this, System.nanoTime());
        }

        @JsonProperty
        public long lastChannelPingNanoTime() {
            return lastPingUpdater.get(this);
        }

        @JsonProperty
        public long lastChannelReadNanoTime() {
            return lastReadUpdater.get(this);
        }

        @JsonProperty
        public long lastChannelWriteNanoTime() {
            return lastWriteUpdater.get(this);
        }

        @JsonProperty
        public long lastChannelWriteAttemptNanoTime() {
            return lastWriteAttemptUpdater.get(this);
        }

        public String toString() {
            return RntbdObjectMapper.toString(this);
        }
    }
}

