/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdChannelAcquisitionTimeline;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpointStatistics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreResponse {
    static final Logger LOGGER = LoggerFactory.getLogger(StoreResponse.class);
    private final int status;
    private final Map<String, String> responseHeaders;
    private final byte[] content;
    private int pendingRequestQueueSize;
    private int requestPayloadLength;
    private int responsePayloadLength;
    private RequestTimeline requestTimeline = RequestTimeline.empty();
    private RntbdChannelAcquisitionTimeline channelAcquisitionTimeline;
    private int rntbdChannelTaskQueueSize;
    private RntbdEndpointStatistics rntbdEndpointStatistics;
    private int rntbdRequestLength;
    private int rntbdResponseLength;

    public StoreResponse(int status, Map<String, String> headerMap, byte[] content) {
        this.responseHeaders = new ConcurrentHashMap<String, String>(headerMap);
        this.status = status;
        this.content = content;
        if (this.content != null) {
            this.responsePayloadLength = this.content.length;
        }
    }

    public int getStatus() {
        return this.status;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public int getRntbdChannelTaskQueueSize() {
        return this.rntbdChannelTaskQueueSize;
    }

    public void setRntbdChannelTaskQueueSize(int rntbdChannelTaskQueueSize) {
        this.rntbdChannelTaskQueueSize = rntbdChannelTaskQueueSize;
    }

    public int getPendingRequestQueueSize() {
        return this.pendingRequestQueueSize;
    }

    public void setRntbdPendingRequestSize(int pendingRequestQueueSize) {
        this.pendingRequestQueueSize = pendingRequestQueueSize;
    }

    public void setRntbdRequestLength(int rntbdRequestLength) {
        this.rntbdRequestLength = rntbdRequestLength;
    }

    public void setRntbdResponseLength(int rntbdResponseLength) {
        this.rntbdResponseLength = rntbdResponseLength;
    }

    public int getRntbdRequestLength() {
        return this.rntbdRequestLength;
    }

    public int getRntbdResponseLength() {
        return this.rntbdResponseLength;
    }

    public int getRequestPayloadLength() {
        return this.requestPayloadLength;
    }

    public void setRequestPayloadLength(int requestPayloadLength) {
        this.requestPayloadLength = requestPayloadLength;
    }

    public byte[] getResponseBody() {
        return this.content;
    }

    public int getResponseBodyLength() {
        return this.responsePayloadLength;
    }

    public long getLSN() {
        String lsnString = this.getHeaderValue("lsn");
        if (StringUtils.isNotEmpty(lsnString)) {
            return Long.parseLong(lsnString);
        }
        return -1L;
    }

    public String getPartitionKeyRangeId() {
        return this.getHeaderValue("x-ms-documentdb-partitionkeyrangeid");
    }

    public String getActivityId() {
        return this.getHeaderValue("x-ms-activity-id");
    }

    public String getCorrelatedActivityId() {
        return this.getHeaderValue("x-ms-cosmos-correlated-activityid");
    }

    public String getHeaderValue(String attribute) {
        return this.responseHeaders.get(attribute);
    }

    public double getRequestCharge() {
        String value = this.getHeaderValue("x-ms-request-charge");
        if (StringUtils.isEmpty(value)) {
            return 0.0;
        }
        return Double.parseDouble(value);
    }

    public String getSessionTokenString() {
        return this.getHeaderValue("x-ms-session-token");
    }

    public void setRequestTimeline(RequestTimeline requestTimeline) {
        this.requestTimeline = requestTimeline;
    }

    RequestTimeline getRequestTimeline() {
        return this.requestTimeline;
    }

    public void setChannelAcquisitionTimeline(RntbdChannelAcquisitionTimeline channelAcquisitionTimeline) {
        this.channelAcquisitionTimeline = channelAcquisitionTimeline;
    }

    RntbdChannelAcquisitionTimeline getChannelAcquisitionTimeline() {
        return this.channelAcquisitionTimeline;
    }

    public void setEndpointStatistics(RntbdEndpointStatistics rntbdEndpointStatistics) {
        this.rntbdEndpointStatistics = rntbdEndpointStatistics;
    }

    RntbdEndpointStatistics getEndpointStatistics() {
        return this.rntbdEndpointStatistics;
    }

    int getSubStatusCode() {
        int subStatusCode = 0;
        String subStatusCodeString = this.getHeaderValue("x-ms-substatus");
        if (StringUtils.isNotEmpty(subStatusCodeString)) {
            try {
                subStatusCode = Integer.parseInt(subStatusCodeString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return subStatusCode;
    }
}

