/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.implementation;

import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedMode;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedStartFromInternal;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedStateDeserializer;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedStateV1;
import com.azure.cosmos.implementation.feedranges.FeedRangeContinuation;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.query.CompositeContinuationToken;
import com.azure.cosmos.implementation.routing.PartitionKeyInternalHelper;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.FeedRange;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@JsonDeserialize(using=ChangeFeedStateDeserializer.class)
public abstract class ChangeFeedState
extends JsonSerializable {
    private static final Comparator<Range<String>> MIN_RANGE_COMPARATOR = new Range.MinComparator<String>();
    private static final Comparator<Range<String>> MAX_RANGE_COMPARATOR = new Range.MaxComparator<String>();

    ChangeFeedState() {
    }

    public abstract FeedRangeContinuation getContinuation();

    public abstract ChangeFeedState setContinuation(FeedRangeContinuation var1);

    public abstract FeedRangeInternal getFeedRange();

    public abstract ChangeFeedMode getMode();

    public abstract ChangeFeedStartFromInternal getStartFromSettings();

    public abstract String applyServerResponseContinuation(String var1, RxDocumentServiceRequest var2);

    public abstract String getContainerRid();

    public static ChangeFeedState fromString(String base64EncodedJson) {
        Preconditions.checkNotNull(base64EncodedJson, "Argument 'base64EncodedJson' must not be null");
        String json = new String(Base64.getUrlDecoder().decode(base64EncodedJson), StandardCharsets.UTF_8);
        ObjectMapper mapper = Utils.getSimpleObjectMapper();
        try {
            return (ChangeFeedState)mapper.readValue(json, ChangeFeedState.class);
        }
        catch (IOException ioException) {
            throw new IllegalArgumentException(String.format("The change feed state continuation contains invalid or unsupported json: %s", json), ioException);
        }
    }

    @Override
    public void populatePropertyBag() {
        super.populatePropertyBag();
    }

    @Override
    public String toString() {
        String json = this.toJson();
        if (json == null) {
            return "";
        }
        return Base64.getUrlEncoder().encodeToString(json.getBytes(StandardCharsets.UTF_8));
    }

    public abstract void populateRequest(RxDocumentServiceRequest var1, int var2);

    public List<CompositeContinuationToken> extractContinuationTokens() {
        return this.extractContinuationTokens(PartitionKeyInternalHelper.FullRange).getLeft();
    }

    private Pair<List<CompositeContinuationToken>, Range<String>> extractContinuationTokens(Range<String> effectiveRange) {
        Preconditions.checkNotNull(effectiveRange);
        ArrayList<CompositeContinuationToken> extractedContinuationTokens = new ArrayList<CompositeContinuationToken>();
        FeedRangeContinuation continuation = this.getContinuation();
        String min = null;
        String max = null;
        if (continuation != null) {
            ArrayList<CompositeContinuationToken> continuationTokensSnapshot = new ArrayList<CompositeContinuationToken>();
            Collections.addAll(continuationTokensSnapshot, continuation.getCurrentContinuationTokens());
            continuationTokensSnapshot.sort(ContinuationTokenRangeComparator.SINGLETON_INSTANCE);
            for (CompositeContinuationToken compositeContinuationToken : continuationTokensSnapshot) {
                if (Range.checkOverlapping(effectiveRange, compositeContinuationToken.getRange())) {
                    Range<String> overlappingRange = this.getOverlappingRange(effectiveRange, compositeContinuationToken.getRange());
                    extractedContinuationTokens.add(new CompositeContinuationToken(compositeContinuationToken.getToken(), overlappingRange));
                    if (min == null) {
                        min = overlappingRange.getMin();
                    }
                    max = overlappingRange.getMax();
                    continue;
                }
                if (extractedContinuationTokens.size() <= 0) continue;
                break;
            }
        }
        Range<String> totalRange = new Range<String>(min != null ? min : PartitionKeyInternalHelper.MinimumInclusiveEffectivePartitionKey, max != null ? max : PartitionKeyInternalHelper.MaximumExclusiveEffectivePartitionKey, true, false);
        return Pair.of(extractedContinuationTokens, totalRange);
    }

    public ChangeFeedState extractForEffectiveRange(Range<String> effectiveRange) {
        Preconditions.checkNotNull(effectiveRange);
        Pair<List<CompositeContinuationToken>, Range<String>> effectiveTokensAndMinMax = this.extractContinuationTokens(effectiveRange);
        List<CompositeContinuationToken> extractedContinuationTokens = effectiveTokensAndMinMax.getLeft();
        Range<String> totalRange = effectiveTokensAndMinMax.getRight();
        FeedRangeEpkImpl feedRange = new FeedRangeEpkImpl(totalRange);
        return new ChangeFeedStateV1(this.getContainerRid(), feedRange, this.getMode(), this.getStartFromSettings(), FeedRangeContinuation.create(this.getContainerRid(), (FeedRangeInternal)feedRange, extractedContinuationTokens));
    }

    private Range<String> getOverlappingRange(Range<String> left, Range<String> right) {
        Preconditions.checkNotNull(left, "Argument 'left' must not be null");
        Preconditions.checkNotNull(right, "Argument 'right' must not be null");
        Preconditions.checkArgument(left.isMinInclusive() && !left.isMaxInclusive(), "Argument 'left' is using exclusive Min or inclusive Max.");
        Preconditions.checkArgument(right.isMinInclusive() && !right.isMaxInclusive(), "Argument 'right' is using exclusive Min or inclusive Max.");
        String min = MIN_RANGE_COMPARATOR.compare(left, right) > 0 ? left.getMin() : right.getMin();
        String max = MAX_RANGE_COMPARATOR.compare(left, right) < 0 ? left.getMax() : right.getMax();
        return new Range<String>(min, max, true, false);
    }

    public static ChangeFeedState merge(ChangeFeedState[] states) {
        Preconditions.checkNotNull(states, "Argument 'states' must not be null.");
        Preconditions.checkArgument(states.length > 0, "Argument 'states' must not be empty.");
        ChangeFeedState firstState = states[0];
        if (states.length == 1) {
            return firstState;
        }
        ArrayList<CompositeContinuationToken> continuationTokens = new ArrayList<CompositeContinuationToken>(states.length);
        for (ChangeFeedState state : states) {
            ChangeFeedState.validateConsistency(state, firstState);
            FeedRangeContinuation continuation = state.getContinuation();
            Collections.addAll(continuationTokens, continuation.getCurrentContinuationTokens());
        }
        continuationTokens.sort(ContinuationTokenRangeComparator.SINGLETON_INSTANCE);
        for (int i = 1; i < continuationTokens.size(); ++i) {
            CompositeContinuationToken previous = (CompositeContinuationToken)continuationTokens.get(i - 1);
            CompositeContinuationToken current = (CompositeContinuationToken)continuationTokens.get(i);
            if (!Range.checkOverlapping(previous.getRange(), current.getRange())) continue;
            throw new IllegalStateException(String.format("Argument 'states' is invalid - it contains overlapping continuations '%s' and '%s'.", previous.toJson(), current.toJson()));
        }
        return new ChangeFeedStateV1(firstState.getContainerRid(), (FeedRangeEpkImpl)FeedRange.forFullRange(), firstState.getMode(), firstState.getStartFromSettings(), FeedRangeContinuation.create(firstState.getContainerRid(), (FeedRangeInternal)((FeedRangeEpkImpl)FeedRange.forFullRange()), continuationTokens));
    }

    private static void validateConsistency(ChangeFeedState candidate, ChangeFeedState expected) {
        String containerRid = candidate.getContainerRid();
        if (Strings.isNullOrEmpty(containerRid) || !containerRid.equals(expected.getContainerRid())) {
            String message = String.format("The container %s for the reference change feed status is different from the current container %s.", expected.getContainerRid(), containerRid);
            throw new IllegalArgumentException(message);
        }
        ChangeFeedMode mode = candidate.getMode();
        if (mode == null || !mode.equals((Object)expected.getMode())) {
            String message = String.format("The mode %s for the reference change feed status is different from the current mode %s.", new Object[]{expected.getMode(), mode});
            throw new IllegalArgumentException(message);
        }
        ChangeFeedStartFromInternal startFrom = candidate.getStartFromSettings();
        if (startFrom == null || !startFrom.toJson().equals(expected.getStartFromSettings().toJson())) {
            String message = String.format("The mode '%s' for the reference change feed status is different from the current mode '%s'.", expected.getStartFromSettings().toJson(), startFrom != null ? startFrom.toJson() : "null");
            throw new IllegalArgumentException(message);
        }
    }

    private static class ContinuationTokenRangeComparator
    implements Comparator<CompositeContinuationToken>,
    Serializable {
        public static final ContinuationTokenRangeComparator SINGLETON_INSTANCE = new ContinuationTokenRangeComparator();
        private static final long serialVersionUID = 1L;

        private ContinuationTokenRangeComparator() {
        }

        @Override
        public int compare(CompositeContinuationToken left, CompositeContinuationToken right) {
            Preconditions.checkNotNull(left, "Argument 'left' must not be null.");
            Preconditions.checkNotNull(right, "Argument 'right' must not be null.");
            return MIN_RANGE_COMPARATOR.compare(left.getRange(), right.getRange());
        }
    }
}

