/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedStartFromInternal;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedStartFromTypes;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.time.Instant;

class ChangeFeedStartFromPointInTimeImpl
extends ChangeFeedStartFromInternal {
    private final Instant pointInTime;

    public ChangeFeedStartFromPointInTimeImpl(Instant pointInTime) {
        if (pointInTime == null) {
            throw new NullPointerException("pointInTime");
        }
        this.pointInTime = pointInTime;
    }

    public Instant getPointInTime() {
        return this.pointInTime;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ChangeFeedStartFromPointInTimeImpl)) {
            return false;
        }
        ChangeFeedStartFromPointInTimeImpl otherStartFrom = (ChangeFeedStartFromPointInTimeImpl)obj;
        return this.pointInTime.equals(otherStartFrom.pointInTime);
    }

    @Override
    public int hashCode() {
        return this.pointInTime.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populatePropertyBag() {
        super.populatePropertyBag();
        ChangeFeedStartFromPointInTimeImpl changeFeedStartFromPointInTimeImpl = this;
        synchronized (changeFeedStartFromPointInTimeImpl) {
            BridgeInternal.setProperty(this, "Type", ChangeFeedStartFromTypes.POINT_IN_TIME);
            BridgeInternal.setProperty(this, "PointInTimeMs", this.pointInTime.toEpochMilli());
        }
    }

    @Override
    public void populateRequest(RxDocumentServiceRequest request) {
        Preconditions.checkNotNull(request, "Argument 'request' must not be null.");
        Instant pointInTime = this.getPointInTime();
        if (pointInTime != START_FROM_BEGINNING_TIME) {
            request.getHeaders().put("If-Modified-Since", Utils.instantAsUTCRFC1123(pointInTime));
        }
    }

    @Override
    public boolean supportsFullFidelityRetention() {
        return false;
    }
}

