/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.implementation;

import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedStartFromBeginningImpl;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedStartFromETagAndFeedRangeImpl;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedStartFromInternal;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedStartFromNowImpl;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedStartFromPointInTimeImpl;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedStartFromTypes;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternalDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.time.Instant;
import java.util.Locale;

public class ChangeFeedStartFromInternalDeserializer
extends StdDeserializer<ChangeFeedStartFromInternal> {
    private static final long serialVersionUID = 1L;

    public ChangeFeedStartFromInternalDeserializer() {
        this(null);
    }

    public ChangeFeedStartFromInternalDeserializer(Class<?> vc) {
        super(vc);
    }

    public ChangeFeedStartFromInternal deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode rootNode = (JsonNode)parser.getCodec().readTree(parser);
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        return ChangeFeedStartFromInternalDeserializer.deserializeStartFromInternal(rootNode, mapper, parser);
    }

    public static ChangeFeedStartFromInternal deserializeStartFromInternal(JsonNode rootNode, ObjectMapper mapper, JsonParser parser) throws IOException {
        ChangeFeedStartFromTypes type;
        JsonNode typeNode = rootNode.get("Type");
        if (typeNode == null || !typeNode.isTextual() || Strings.isNullOrWhiteSpace(typeNode.textValue())) {
            throw JsonMappingException.from((JsonParser)parser, (String)String.format("Required property '%s' missing or does not have a valid value.", "Type"));
        }
        try {
            type = ChangeFeedStartFromTypes.valueOf(typeNode.textValue().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException argException) {
            throw JsonMappingException.from((JsonParser)parser, (String)String.format("Value '%s' for required property '%s' does not have a valid value.", typeNode.textValue(), "Type"), (Throwable)argException);
        }
        switch (type) {
            case BEGINNING: {
                return new ChangeFeedStartFromBeginningImpl();
            }
            case NOW: {
                return new ChangeFeedStartFromNowImpl();
            }
            case POINT_IN_TIME: {
                JsonNode pitNode = rootNode.get("PointInTimeMs");
                if (pitNode == null || !pitNode.isLong()) {
                    throw JsonMappingException.from((JsonParser)parser, (String)String.format("Required property '%s' missing or does not have a valid value.", "PointInTimeMs"));
                }
                return new ChangeFeedStartFromPointInTimeImpl(Instant.ofEpochMilli(pitNode.longValue()));
            }
            case LEASE: {
                JsonNode eTagNode = rootNode.get("Etag");
                if (eTagNode == null || !eTagNode.isTextual() || Strings.isNullOrWhiteSpace(eTagNode.textValue())) {
                    throw JsonMappingException.from((JsonParser)parser, (String)String.format("Required property '%s' missing or does not have a valid value.", "Etag"));
                }
                FeedRangeInternal feedRange = FeedRangeInternalDeserializer.deserializeFeedRange(rootNode, mapper, parser);
                return new ChangeFeedStartFromETagAndFeedRangeImpl(eTagNode.textValue(), feedRange);
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)type));
    }
}

