/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import java.util.Locale;

public enum ResourceType {
    Unknown("Unknown", -1),
    Attachment("Attachment", 3),
    BatchApply("BatchApply", 112),
    DocumentCollection("DocumentCollection", 1),
    ComputeGatewayCharges("ComputeGatewayCharges", 131),
    Conflict("Conflict", 107),
    Database("Database", 0),
    DatabaseAccount("DatabaseAccount", 118),
    Document("Document", 2),
    Index("Index", 104),
    IndexBookmark("IndexBookmark", 105),
    IndexSize("IndexSize", 106),
    LargeInvalid("LargeInvalid", 100),
    LogStoreLogs("LogStoreLogs", 126),
    MasterPartition("MasterPartition", 120),
    Module("Module", 9),
    ModuleCommand("ModuleCommand", 103),
    Offer("Offer", 113),
    PartitionKeyRange("PartitionKeyRange", 125),
    PartitionKey("PartitionKey", 136),
    PartitionSetInformation("PartitionSetInformation", 114),
    Permission("Permission", 5),
    PreviousImage("PreviousImage", 128),
    Progress("Progress", 6),
    Record("Record", 108),
    Replica("Replica", 7),
    RestoreMetadata("RestoreMetadata", 127),
    RidRange("RidRange", 130),
    Schema("Schema", 124),
    SchemaContainer("SchemaContainer", 123),
    ServerPartition("ServerPartition", 121),
    SmallMaxInvalid("SmallMaxInvalid", 10),
    StoredProcedure("StoredProcedure", 109),
    Timestamp("Timestamp", 117),
    Tombstone("Tombstone", 8),
    Topology("Topology", 122),
    Trigger("Trigger", 110),
    User("User", 4),
    UserDefinedFunction("UserDefinedFunction", 111),
    UserDefinedType("UserDefinedType", 133),
    VectorClock("VectorClock", 129),
    XPReplicatorAddress("XPReplicatorAddress", 115),
    Address("Address", -5),
    Key("Key", -2),
    Media("Media", -3),
    ServiceFabricService("ServiceFabricService", -4),
    ClientEncryptionKey("ClientEncryptionKey", 141),
    ClientTelemetry("ClientTelemetry", 1001);

    private final int value;
    private final String stringValue;
    private final String toLowerStringValue;

    private ResourceType(String stringValue, int value) {
        this.stringValue = stringValue;
        this.value = value;
        this.toLowerStringValue = stringValue.toLowerCase(Locale.ROOT);
    }

    public String toString() {
        return this.stringValue;
    }

    public String toLowerCase() {
        return this.toLowerStringValue;
    }

    public int value() {
        return this.value;
    }

    public boolean isCollectionChild() {
        return this == Document || this == Attachment || this == Conflict || this == Schema || this.isScript();
    }

    public boolean isMasterResource() {
        return this == Offer || this == Database || this == User || this == Permission || this == Topology || this == PartitionKeyRange || this == DocumentCollection || this == ClientEncryptionKey;
    }

    public boolean isPartitioned() {
        return this == Document || this == Attachment || this == Conflict;
    }

    public boolean isScript() {
        return this == UserDefinedFunction || this == Trigger || this == StoredProcedure;
    }
}

