/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.CosmosError;
import com.azure.cosmos.implementation.directconnectivity.HttpUtils;
import com.azure.cosmos.implementation.http.HttpHeaders;
import java.net.URI;
import java.util.Map;

public class ForbiddenException
extends CosmosException {
    ForbiddenException() {
        this("Unable to proceed with the request. Please check the authorization claims to ensure the required permissions to process the request.");
    }

    public ForbiddenException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(403, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    ForbiddenException(String message) {
        this(message, null, null, null);
    }

    ForbiddenException(String message, HttpHeaders headers, String requestUrlString) {
        this(message, null, headers, requestUrlString);
    }

    public ForbiddenException(String message, HttpHeaders headers, URI requestUri) {
        this(message, headers, requestUri != null ? requestUri.toString() : null);
    }

    ForbiddenException(Exception innerException) {
        this("Unable to proceed with the request. Please check the authorization claims to ensure the required permissions to process the request.", innerException, null, null);
    }

    ForbiddenException(String message, Exception innerException, HttpHeaders headers, String requestUrlString) {
        super(String.format("%s: %s", "Unable to proceed with the request. Please check the authorization claims to ensure the required permissions to process the request.", message), innerException, HttpUtils.asMap(headers), 403, requestUrlString);
    }
}

