/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.models.CosmosConflictRequestOptions;
import com.azure.cosmos.models.CosmosConflictResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import reactor.core.publisher.Mono;

public final class CosmosAsyncConflict {
    private final CosmosAsyncContainer container;
    private String id;

    CosmosAsyncConflict(String id, CosmosAsyncContainer container) {
        this.id = id;
        this.container = container;
    }

    public String getId() {
        return this.id;
    }

    CosmosAsyncConflict setId(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosConflictResponse> read(CosmosConflictRequestOptions options) {
        if (options == null) {
            options = new CosmosConflictRequestOptions();
        }
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return FluxUtil.withContext(context -> this.readInternal(requestOptions, (Context)context));
    }

    public Mono<CosmosConflictResponse> delete(CosmosConflictRequestOptions options) {
        if (options == null) {
            options = new CosmosConflictRequestOptions();
        }
        RequestOptions requestOptions = ModelBridgeInternal.toRequestOptions(options);
        return FluxUtil.withContext(context -> this.deleteInternal(requestOptions, (Context)context));
    }

    String getURIPathSegment() {
        return "conflicts";
    }

    String getParentLink() {
        return this.container.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParentLink());
        builder.append("/");
        builder.append(this.getURIPathSegment());
        builder.append("/");
        builder.append(this.getId());
        return builder.toString();
    }

    private Mono<CosmosConflictResponse> readInternal(RequestOptions options, Context context) {
        String spanName = "readConflict." + this.getId();
        Mono responseMono = this.container.getDatabase().getDocClientWrapper().readConflict(this.getLink(), options).map(response -> ModelBridgeInternal.createCosmosConflictResponse(response)).single();
        return this.container.getDatabase().getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.container.getDatabase().getId(), this.container.getDatabase().getClient().getServiceEndpoint());
    }

    private Mono<CosmosConflictResponse> deleteInternal(RequestOptions options, Context context) {
        String spanName = "deleteConflict." + this.getId();
        Mono responseMono = this.container.getDatabase().getDocClientWrapper().deleteConflict(this.getLink(), options).map(response -> ModelBridgeInternal.createCosmosConflictResponse(response)).single();
        return this.container.getDatabase().getClient().getTracerProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.container.getDatabase().getId(), this.container.getDatabase().getClient().getServiceEndpoint());
    }
}

