/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.CryptographyExtensions;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.DateTimeOffset;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.GregorianChange;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.JDBCType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionExceptionResource;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.Nanos;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SSType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.UTC;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.UUID;

final class SqlSerializerUtil {
    static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final int DAYS_INTO_CE_LENGTH = 3;
    static final int MINUTES_OFFSET_LENGTH = 2;
    static final int MAX_FRACTIONAL_SECONDS_SCALE = 7;
    static final int maxDecimalPrecision = 38;
    static final int defaultDecimalPrecision = 18;
    private static final int MAX = -1;
    static final int DAYS_PER_YEAR = 365;
    static final int BASE_YEAR_1900 = 1900;
    static final int BASE_YEAR_1970 = 1970;
    static final String BASE_DATE_1970 = "1970-01-01";
    private static final BigInteger maxRPCDecimalValue = new BigInteger("99999999999999999999999999999999999999");

    SqlSerializerUtil() {
    }

    public static byte[] normalizedValue(JDBCType destJdbcType, Object value, int destPrecision, int destScale, String codepage) throws MicrosoftDataEncryptionException {
        switch (destJdbcType) {
            case CHAR: 
            case VARCHAR: 
            case LONGVARCHAR: {
                if (destPrecision != -1 && ((String)value).length() > destPrecision) {
                    MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidPSLength"));
                    Object[] msgArgs = new Object[]{value, destJdbcType, destPrecision, destScale};
                    throw new MicrosoftDataEncryptionException(form.format(msgArgs));
                }
                return ((String)value).getBytes(Charset.forName(codepage));
            }
            case NCHAR: 
            case NVARCHAR: 
            case LONGNVARCHAR: {
                if (destPrecision != -1 && ((String)value).length() > destPrecision) {
                    MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidPSLength"));
                    Object[] msgArgs = new Object[]{value, destJdbcType, destPrecision, destScale};
                    throw new MicrosoftDataEncryptionException(form.format(msgArgs));
                }
                return ((String)value).getBytes(Charset.forName(codepage));
            }
        }
        MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidType"));
        Object[] msgArgs = new Object[]{destJdbcType};
        throw new MicrosoftDataEncryptionException(form.format(msgArgs));
    }

    public static byte[] normalizedValue(JDBCType destJdbcType, Object value, int destPrecision, int destScale) throws MicrosoftDataEncryptionException {
        Long longValue = null;
        byte[] byteValue = null;
        try {
            switch (destJdbcType) {
                case BIT: {
                    longValue = (Boolean)value != false ? 1 : 0;
                    return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(longValue).array();
                }
                case TINYINT: 
                case SMALLINT: {
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        short shortValue = (short)intValue;
                        longValue = shortValue;
                    } else {
                        longValue = (long)((Short)value);
                    }
                    return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(longValue).array();
                }
                case INTEGER: {
                    longValue = (long)((Integer)value);
                    return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(longValue).array();
                }
                case BIGINT: {
                    longValue = (long)((Long)value);
                    return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(longValue).array();
                }
                case BINARY: 
                case VARBINARY: 
                case LONGVARBINARY: {
                    byte[] byteArrayValue = value instanceof String ? CryptographyExtensions.fromHexString((String)value) : (byte[])value;
                    if (destPrecision != -1 && byteArrayValue.length > destPrecision) {
                        MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidPSLength"));
                        Object[] msgArgs = new Object[]{byteArrayValue, destJdbcType, destPrecision, destScale};
                        throw new MicrosoftDataEncryptionException(form.format(msgArgs));
                    }
                    return byteArrayValue;
                }
                case GUID: {
                    return SqlSerializerUtil.asGuidByteArray(UUID.fromString((String)value));
                }
                case CHAR: 
                case VARCHAR: 
                case LONGVARCHAR: {
                    if (destPrecision != -1 && ((String)value).length() > destPrecision) {
                        MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidPSLength"));
                        Object[] msgArgs = new Object[]{value, destJdbcType, destPrecision, destScale};
                        throw new MicrosoftDataEncryptionException(form.format(msgArgs));
                    }
                    return ((String)value).getBytes(StandardCharsets.UTF_8);
                }
                case NCHAR: 
                case NVARCHAR: 
                case LONGNVARCHAR: {
                    if (destPrecision != -1 && ((String)value).length() > destPrecision) {
                        MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidPSLength"));
                        Object[] msgArgs = new Object[]{value, destJdbcType, destPrecision, destScale};
                        throw new MicrosoftDataEncryptionException(form.format(msgArgs));
                    }
                    return ((String)value).getBytes(StandardCharsets.UTF_16LE);
                }
                case REAL: {
                    Float floatValue = Float.valueOf(value instanceof String ? Float.parseFloat((String)value) : ((Float)value).floatValue());
                    return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(floatValue.floatValue()).array();
                }
                case FLOAT: 
                case DOUBLE: {
                    Double doubleValue = value instanceof String ? Double.parseDouble((String)value) : (Double)value;
                    return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putDouble(doubleValue).array();
                }
                case NUMERIC: 
                case DECIMAL: {
                    int srcDataScale = ((BigDecimal)value).scale();
                    int srcDataPrecision = ((BigDecimal)value).precision();
                    BigDecimal bigDataValue = (BigDecimal)value;
                    if (destPrecision != -1 && srcDataPrecision > destPrecision || srcDataScale > destScale) {
                        MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidPSLength"));
                        Object[] msgArgs = new Object[]{value, destJdbcType, destPrecision, destScale};
                        throw new MicrosoftDataEncryptionException(form.format(msgArgs));
                    }
                    if (srcDataScale < destScale) {
                        bigDataValue = bigDataValue.setScale(destScale);
                    }
                    byteValue = SqlSerializerUtil.convertBigDecimalToBytes(bigDataValue, bigDataValue.scale());
                    byte[] decimalbyteValue = new byte[16];
                    System.arraycopy(byteValue, 2, decimalbyteValue, 0, byteValue.length - 2);
                    return decimalbyteValue;
                }
                case SMALLMONEY: 
                case MONEY: {
                    BigDecimal bdValue = (BigDecimal)value;
                    SqlSerializerUtil.validateMoneyRange(bdValue, destJdbcType);
                    int digitCount = bdValue.precision() - bdValue.scale() + 4;
                    long moneyVal = ((BigDecimal)value).multiply(new BigDecimal(10000), new MathContext(digitCount, RoundingMode.HALF_UP)).longValue();
                    ByteBuffer bbuf = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
                    bbuf.putInt((int)(moneyVal >> 32)).array();
                    bbuf.putInt((int)moneyVal).array();
                    return bbuf.array();
                }
                case DATE: {
                    GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault(), Locale.US);
                    calendar.setLenient(true);
                    calendar.clear();
                    calendar.setTimeInMillis(((Date)value).getTime());
                    return SqlSerializerUtil.getNormalizedTemporal(calendar, 0, 0, SSType.DATE, (short)0);
                }
                case TIME: {
                    int subSecondNanos;
                    GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault(), Locale.US);
                    calendar.setLenient(true);
                    calendar.clear();
                    long utcMillis = value instanceof Timestamp ? ((Timestamp)value).getTime() : ((Time)value).getTime();
                    calendar.setTimeInMillis(utcMillis);
                    if (value instanceof Timestamp) {
                        subSecondNanos = ((Timestamp)value).getNanos();
                    } else {
                        subSecondNanos = 1000000 * (int)(utcMillis % 1000L);
                        if (subSecondNanos < 0) {
                            subSecondNanos += 1000000000;
                        }
                    }
                    return SqlSerializerUtil.getNormalizedTemporal(calendar, subSecondNanos, destScale, SSType.TIME, (short)0);
                }
                case TIMESTAMP: {
                    GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault(), Locale.US);
                    calendar.setLenient(true);
                    calendar.clear();
                    long utcMillis = ((Timestamp)value).getTime();
                    calendar.setTimeInMillis(utcMillis);
                    int subSecondNanos = ((Timestamp)value).getNanos();
                    return SqlSerializerUtil.getNormalizedTemporal(calendar, subSecondNanos, destScale, SSType.DATETIME2, (short)0);
                }
                case DATETIME: 
                case SMALLDATETIME: {
                    GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault(), Locale.US);
                    calendar.setLenient(true);
                    calendar.clear();
                    long utcMillis = ((Timestamp)value).getTime();
                    calendar.setTimeInMillis(utcMillis);
                    int subSecondNanos = ((Timestamp)value).getNanos();
                    return SqlSerializerUtil.getNormalizedDateTimeAsBytes(calendar, subSecondNanos, destJdbcType);
                }
                case DATETIMEOFFSET: {
                    DateTimeOffset dtoValue = (DateTimeOffset)value;
                    long utcMillis = dtoValue.getTimestamp().getTime();
                    int subSecondNanos = dtoValue.getTimestamp().getNanos();
                    int minutesOffset = dtoValue.getMinutesOffset();
                    GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                    calendar.setLenient(true);
                    calendar.clear();
                    calendar.setTimeInMillis(utcMillis);
                    return SqlSerializerUtil.getNormalizedTemporal(calendar, subSecondNanos, destScale, SSType.DATETIMEOFFSET, (short)minutesOffset);
                }
            }
            MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidType"));
            Object[] msgArgs = new Object[]{destJdbcType};
            throw new MicrosoftDataEncryptionException(form.format(msgArgs));
        }
        catch (NumberFormatException ex) {
            MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidValueToType"));
            Object[] msgArgs = new Object[]{destJdbcType};
            throw new MicrosoftDataEncryptionException(form.format(msgArgs));
        }
        catch (IllegalArgumentException ex) {
            MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidValueToType"));
            Object[] msgArgs = new Object[]{destJdbcType};
            throw new MicrosoftDataEncryptionException(form.format(msgArgs));
        }
        catch (ClassCastException ex) {
            MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidValueToType"));
            Object[] msgArgs = new Object[]{destJdbcType};
            throw new MicrosoftDataEncryptionException(form.format(msgArgs));
        }
    }

    public static Object denormalizedValue(byte[] decryptedValue, JDBCType jdbcType, SSType ssType, int precision, int scale, Calendar cal, String codepage) throws MicrosoftDataEncryptionException {
        Charset charset = Charset.forName(codepage);
        switch (ssType) {
            case CHAR: 
            case VARCHAR: 
            case NCHAR: 
            case NVARCHAR: 
            case VARCHARMAX: 
            case NVARCHARMAX: {
                try {
                    String strVal = new String(decryptedValue, 0, decryptedValue.length, charset);
                    if (SSType.CHAR == ssType || SSType.NCHAR == ssType) {
                        StringBuilder sb = new StringBuilder(strVal);
                        int padLength = precision - strVal.length();
                        for (int i = 0; i < padLength; ++i) {
                            sb.append(' ');
                        }
                        strVal = sb.toString();
                    }
                    return SqlSerializerUtil.convertStringToObject(strVal, jdbcType);
                }
                catch (IllegalArgumentException e) {
                    MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidDataType"));
                    Object[] msgArgs = new Object[]{ssType};
                    throw new MicrosoftDataEncryptionException(form.format(msgArgs));
                }
                catch (UnsupportedEncodingException e) {
                    MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidEncoding"));
                    Object[] msgArgs = new Object[]{charset};
                    throw new MicrosoftDataEncryptionException(form.format(msgArgs));
                }
            }
        }
        MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidDataType"));
        Object[] msgArgs = new Object[]{ssType};
        throw new MicrosoftDataEncryptionException(form.format(msgArgs));
    }

    public static Object denormalizedValue(byte[] decryptedValue, JDBCType jdbcType, SSType ssType, int precision, int scale, Calendar cal) throws MicrosoftDataEncryptionException {
        Charset charset = null;
        switch (ssType) {
            case CHAR: 
            case VARCHAR: 
            case NCHAR: 
            case NVARCHAR: 
            case VARCHARMAX: 
            case NVARCHARMAX: {
                try {
                    switch (ssType) {
                        case CHAR: 
                        case VARCHAR: 
                        case VARCHARMAX: {
                            charset = StandardCharsets.UTF_8;
                            break;
                        }
                        case NCHAR: 
                        case NVARCHAR: 
                        case NVARCHARMAX: {
                            charset = StandardCharsets.UTF_16LE;
                            break;
                        }
                        default: {
                            MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidDataType"));
                            Object[] msgArgs = new Object[]{ssType};
                            throw new MicrosoftDataEncryptionException(form.format(msgArgs));
                        }
                    }
                    String strVal = new String(decryptedValue, 0, decryptedValue.length, charset);
                    if (SSType.CHAR == ssType || SSType.NCHAR == ssType) {
                        StringBuilder sb = new StringBuilder(strVal);
                        int padLength = precision - strVal.length();
                        for (int i = 0; i < padLength; ++i) {
                            sb.append(' ');
                        }
                        strVal = sb.toString();
                    }
                    return SqlSerializerUtil.convertStringToObject(strVal, jdbcType);
                }
                catch (IllegalArgumentException e) {
                    MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidDataType"));
                    Object[] msgArgs = new Object[]{ssType};
                    throw new MicrosoftDataEncryptionException(form.format(msgArgs));
                }
                catch (UnsupportedEncodingException e) {
                    MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidEncoding"));
                    Object[] msgArgs = new Object[]{charset};
                    throw new MicrosoftDataEncryptionException(form.format(msgArgs));
                }
            }
            case BIT: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                if (8 != decryptedValue.length) {
                    MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidDataType"));
                    Object[] msgArgs = new Object[]{ssType};
                    throw new MicrosoftDataEncryptionException(form.format(msgArgs));
                }
                return SqlSerializerUtil.convertLongToObject(SqlSerializerUtil.readLong(decryptedValue, 0), jdbcType, ssType);
            }
            case REAL: 
            case FLOAT: {
                if (8 == decryptedValue.length) {
                    return SqlSerializerUtil.convertDoubleToObject(ByteBuffer.wrap(decryptedValue).order(ByteOrder.LITTLE_ENDIAN).getDouble(), JDBCType.VARBINARY == jdbcType ? ssType.getJDBCType() : jdbcType);
                }
                if (4 == decryptedValue.length) {
                    return SqlSerializerUtil.convertFloatToObject(ByteBuffer.wrap(decryptedValue).order(ByteOrder.LITTLE_ENDIAN).getFloat(), JDBCType.VARBINARY == jdbcType ? ssType.getJDBCType() : jdbcType);
                }
                MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidDataType"));
                Object[] msgArgs = new Object[]{ssType};
                throw new MicrosoftDataEncryptionException(form.format(msgArgs));
            }
            case SMALLMONEY: {
                return SqlSerializerUtil.convertMoneyToObject(new BigDecimal(BigInteger.valueOf(SqlSerializerUtil.readInt(decryptedValue, 4)), 4), JDBCType.VARBINARY == jdbcType ? ssType.getJDBCType() : jdbcType, 4);
            }
            case MONEY: {
                BigInteger bi = BigInteger.valueOf((long)SqlSerializerUtil.readInt(decryptedValue, 0) << 32 | (long)SqlSerializerUtil.readInt(decryptedValue, 4) & 0xFFFFFFFFL);
                return SqlSerializerUtil.convertMoneyToObject(new BigDecimal(bi, 4), JDBCType.VARBINARY == jdbcType ? ssType.getJDBCType() : jdbcType, 8);
            }
            case NUMERIC: 
            case DECIMAL: {
                return SqlSerializerUtil.convertBigDecimalToObject(SqlSerializerUtil.readBigDecimal(decryptedValue, decryptedValue.length, scale), JDBCType.VARBINARY == jdbcType ? ssType.getJDBCType() : jdbcType);
            }
            case BINARY: 
            case VARBINARY: 
            case VARBINARYMAX: {
                return SqlSerializerUtil.convertBytesToObject(decryptedValue, jdbcType, ssType, precision);
            }
            case DATE: {
                if (3 != decryptedValue.length) {
                    MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidDataType"));
                    Object[] msgArgs = new Object[]{ssType};
                    throw new MicrosoftDataEncryptionException(form.format(msgArgs));
                }
                int daysIntoCE = SqlSerializerUtil.getDaysIntoCE(decryptedValue, ssType);
                return SqlSerializerUtil.convertTemporalToObject(jdbcType, ssType, cal, daysIntoCE, 0L, 0);
            }
            case TIME: {
                long localNanosSinceMidnight = SqlSerializerUtil.readNanosSinceMidnightAE(decryptedValue, scale, ssType);
                return SqlSerializerUtil.convertTemporalToObject(jdbcType, SSType.TIME, cal, 0, localNanosSinceMidnight, scale);
            }
            case DATETIME2: {
                if (8 != decryptedValue.length) {
                    MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidDataType"));
                    Object[] msgArgs = new Object[]{ssType};
                    throw new MicrosoftDataEncryptionException(form.format(msgArgs));
                }
                int dateOffset = decryptedValue.length - 3;
                byte[] timePortion = new byte[dateOffset];
                byte[] datePortion = new byte[3];
                System.arraycopy(decryptedValue, 0, timePortion, 0, dateOffset);
                System.arraycopy(decryptedValue, dateOffset, datePortion, 0, 3);
                long localNanosSinceMidnight = SqlSerializerUtil.readNanosSinceMidnightAE(timePortion, scale, ssType);
                int daysIntoCE = SqlSerializerUtil.getDaysIntoCE(datePortion, ssType);
                return SqlSerializerUtil.convertTemporalToObject(jdbcType, SSType.DATETIME2, cal, daysIntoCE, localNanosSinceMidnight, scale);
            }
            case SMALLDATETIME: {
                if (4 != decryptedValue.length) {
                    MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidDataType"));
                    Object[] msgArgs = new Object[]{ssType};
                    throw new MicrosoftDataEncryptionException(form.format(msgArgs));
                }
                return SqlSerializerUtil.convertTemporalToObject(jdbcType, SSType.DATETIME, cal, SqlSerializerUtil.readUnsignedShort(decryptedValue, 0), (long)SqlSerializerUtil.readUnsignedShort(decryptedValue, 2) * 60L * 1000L, 0);
            }
            case DATETIME: {
                long ticksSinceMidnight = ((long)SqlSerializerUtil.readInt(decryptedValue, 4) * 10L + 1L) / 3L;
                if (8 != decryptedValue.length || Integer.MAX_VALUE < ticksSinceMidnight || ticksSinceMidnight < 0L) {
                    MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidDataType"));
                    Object[] msgArgs = new Object[]{ssType};
                    throw new MicrosoftDataEncryptionException(form.format(msgArgs));
                }
                return SqlSerializerUtil.convertTemporalToObject(jdbcType, SSType.DATETIME, cal, SqlSerializerUtil.readInt(decryptedValue, 0), ticksSinceMidnight, 0);
            }
            case DATETIMEOFFSET: {
                int dateOffset = decryptedValue.length - 5;
                byte[] timePortion = new byte[dateOffset];
                byte[] datePortion = new byte[3];
                byte[] offsetPortion = new byte[2];
                System.arraycopy(decryptedValue, 0, timePortion, 0, dateOffset);
                System.arraycopy(decryptedValue, dateOffset, datePortion, 0, 3);
                System.arraycopy(decryptedValue, dateOffset + 3, offsetPortion, 0, 2);
                long localNanosSinceMidnight = SqlSerializerUtil.readNanosSinceMidnightAE(timePortion, scale, ssType);
                int daysIntoCE = SqlSerializerUtil.getDaysIntoCE(datePortion, ssType);
                short localMinutesOffset = ByteBuffer.wrap(offsetPortion).order(ByteOrder.LITTLE_ENDIAN).getShort();
                return SqlSerializerUtil.convertTemporalToObject(jdbcType, SSType.DATETIMEOFFSET, new GregorianCalendar(new SimpleTimeZone(localMinutesOffset * 60 * 1000, ""), Locale.US), daysIntoCE, localNanosSinceMidnight, scale);
            }
            case GUID: {
                return SqlSerializerUtil.readGUID(decryptedValue);
            }
        }
        MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidDataType"));
        Object[] msgArgs = new Object[]{ssType};
        throw new MicrosoftDataEncryptionException(form.format(msgArgs));
    }

    static final Object convertIntegerToObject(int intValue, int valueLength, JDBCType jdbcType) {
        switch (jdbcType) {
            case INTEGER: {
                return intValue;
            }
            case TINYINT: 
            case SMALLINT: {
                return (short)intValue;
            }
            case BIT: 
            case BOOLEAN: {
                return 0 != intValue;
            }
            case BIGINT: {
                return (long)intValue;
            }
            case NUMERIC: 
            case DECIMAL: 
            case SMALLMONEY: 
            case MONEY: {
                return new BigDecimal(Integer.toString(intValue));
            }
            case FLOAT: 
            case DOUBLE: {
                return (double)intValue;
            }
            case REAL: {
                return Float.valueOf(intValue);
            }
            case BINARY: {
                return SqlSerializerUtil.convertIntToBytes(intValue, valueLength);
            }
            case SQL_VARIANT: {
                if (valueLength == 1) {
                    return 0 != intValue;
                }
                if (valueLength == 3 || valueLength == 4) {
                    return (short)intValue;
                }
                return intValue;
            }
        }
        return Integer.toString(intValue);
    }

    static final Object convertLongToObject(long longVal, JDBCType jdbcType, SSType baseSSType) {
        switch (jdbcType) {
            case BIGINT: 
            case SQL_VARIANT: {
                return longVal;
            }
            case INTEGER: {
                return (int)longVal;
            }
            case TINYINT: 
            case SMALLINT: {
                return (short)longVal;
            }
            case BIT: 
            case BOOLEAN: {
                return 0L != longVal;
            }
            case NUMERIC: 
            case DECIMAL: 
            case SMALLMONEY: 
            case MONEY: {
                return new BigDecimal(Long.toString(longVal));
            }
            case FLOAT: 
            case DOUBLE: {
                return (double)longVal;
            }
            case REAL: {
                return Float.valueOf(longVal);
            }
            case BINARY: {
                byte[] convertedBytes = SqlSerializerUtil.convertLongToBytes(longVal);
                switch (baseSSType) {
                    case BIT: 
                    case TINYINT: {
                        int bytesToReturnLength = 1;
                        byte[] bytesToReturn = new byte[bytesToReturnLength];
                        System.arraycopy(convertedBytes, convertedBytes.length - bytesToReturnLength, bytesToReturn, 0, bytesToReturnLength);
                        return bytesToReturn;
                    }
                    case SMALLINT: {
                        int bytesToReturnLength = 2;
                        byte[] bytesToReturn = new byte[bytesToReturnLength];
                        System.arraycopy(convertedBytes, convertedBytes.length - bytesToReturnLength, bytesToReturn, 0, bytesToReturnLength);
                        return bytesToReturn;
                    }
                    case INTEGER: {
                        int bytesToReturnLength = 4;
                        byte[] bytesToReturn = new byte[bytesToReturnLength];
                        System.arraycopy(convertedBytes, convertedBytes.length - bytesToReturnLength, bytesToReturn, 0, bytesToReturnLength);
                        return bytesToReturn;
                    }
                    case BIGINT: {
                        int bytesToReturnLength = 8;
                        byte[] bytesToReturn = new byte[bytesToReturnLength];
                        System.arraycopy(convertedBytes, convertedBytes.length - bytesToReturnLength, bytesToReturn, 0, bytesToReturnLength);
                        return bytesToReturn;
                    }
                }
                return convertedBytes;
            }
            case VARBINARY: {
                switch (baseSSType) {
                    case BIGINT: {
                        return longVal;
                    }
                    case INTEGER: {
                        return (int)longVal;
                    }
                    case TINYINT: 
                    case SMALLINT: {
                        return (short)longVal;
                    }
                    case BIT: {
                        return 0L != longVal;
                    }
                    case SMALLMONEY: 
                    case MONEY: 
                    case NUMERIC: 
                    case DECIMAL: {
                        return new BigDecimal(Long.toString(longVal));
                    }
                    case FLOAT: {
                        return (double)longVal;
                    }
                    case REAL: {
                        return Float.valueOf(longVal);
                    }
                    case BINARY: {
                        return SqlSerializerUtil.convertLongToBytes(longVal);
                    }
                }
                return Long.toString(longVal);
            }
        }
        return Long.toString(longVal);
    }

    static final byte[] convertIntToBytes(int intValue, int valueLength) {
        byte[] bytes = new byte[valueLength];
        int i = valueLength;
        while (i-- > 0) {
            bytes[i] = (byte)(intValue & 0xFF);
            intValue >>= 8;
        }
        return bytes;
    }

    static final Object convertFloatToObject(float floatVal, JDBCType jdbcType) {
        switch (jdbcType) {
            case REAL: 
            case SQL_VARIANT: {
                return Float.valueOf(floatVal);
            }
            case INTEGER: {
                return (int)floatVal;
            }
            case TINYINT: 
            case SMALLINT: {
                return (short)floatVal;
            }
            case BIT: 
            case BOOLEAN: {
                return 0 != Float.compare(0.0f, floatVal);
            }
            case BIGINT: {
                return (long)floatVal;
            }
            case NUMERIC: 
            case DECIMAL: 
            case SMALLMONEY: 
            case MONEY: {
                return new BigDecimal(Float.toString(floatVal));
            }
            case FLOAT: 
            case DOUBLE: {
                return Float.valueOf(floatVal).doubleValue();
            }
            case BINARY: {
                return SqlSerializerUtil.convertIntToBytes(Float.floatToRawIntBits(floatVal), 4);
            }
        }
        return Float.toString(floatVal);
    }

    static final byte[] convertLongToBytes(long longValue) {
        byte[] bytes = new byte[8];
        int i = 8;
        while (i-- > 0) {
            bytes[i] = (byte)(longValue & 0xFFL);
            longValue >>= 8;
        }
        return bytes;
    }

    static final Object convertDoubleToObject(double doubleVal, JDBCType jdbcType) {
        switch (jdbcType) {
            case FLOAT: 
            case DOUBLE: 
            case SQL_VARIANT: {
                return doubleVal;
            }
            case REAL: {
                return Float.valueOf(Double.valueOf(doubleVal).floatValue());
            }
            case INTEGER: {
                return (int)doubleVal;
            }
            case TINYINT: 
            case SMALLINT: {
                return (short)doubleVal;
            }
            case BIT: 
            case BOOLEAN: {
                return 0 != Double.compare(0.0, doubleVal);
            }
            case BIGINT: {
                return (long)doubleVal;
            }
            case NUMERIC: 
            case DECIMAL: 
            case SMALLMONEY: 
            case MONEY: {
                return new BigDecimal(Double.toString(doubleVal));
            }
            case BINARY: {
                return SqlSerializerUtil.convertLongToBytes(Double.doubleToRawLongBits(doubleVal));
            }
        }
        return Double.toString(doubleVal);
    }

    static final byte[] convertBigDecimalToBytes(BigDecimal bigDecimalVal, int scale) {
        byte[] valueBytes;
        if (bigDecimalVal == null) {
            valueBytes = new byte[]{(byte)scale, 0};
        } else {
            boolean isNegative;
            boolean bl = isNegative = bigDecimalVal.signum() < 0;
            if (bigDecimalVal.scale() < 0) {
                bigDecimalVal = bigDecimalVal.setScale(0);
            }
            BigInteger bi = bigDecimalVal.unscaledValue();
            if (isNegative) {
                bi = bi.negate();
            }
            byte[] unscaledBytes = bi.toByteArray();
            valueBytes = new byte[unscaledBytes.length + 3];
            int j = 0;
            valueBytes[j++] = (byte)bigDecimalVal.scale();
            valueBytes[j++] = (byte)(unscaledBytes.length + 1);
            valueBytes[j++] = (byte)(!isNegative ? 1 : 0);
            for (int i = unscaledBytes.length - 1; i >= 0; --i) {
                valueBytes[j++] = unscaledBytes[i];
            }
        }
        return valueBytes;
    }

    static final byte[] convertMoneyToBytes(BigDecimal bigDecimalVal, int bLength) {
        byte[] valueBytes = new byte[bLength];
        BigInteger bi = bigDecimalVal.unscaledValue();
        if (bLength == 8) {
            byte[] longbArray = new byte[bLength];
            SqlSerializerUtil.writeLong(bi.longValue(), longbArray, 0);
            System.arraycopy(longbArray, 0, valueBytes, 4, 4);
            System.arraycopy(longbArray, 4, valueBytes, 0, 4);
        } else {
            SqlSerializerUtil.writeInt(bi.intValue(), valueBytes, 0);
        }
        return valueBytes;
    }

    static final Object convertBigDecimalToObject(BigDecimal bigDecimalVal, JDBCType jdbcType) {
        switch (jdbcType) {
            case NUMERIC: 
            case DECIMAL: 
            case SMALLMONEY: 
            case MONEY: 
            case SQL_VARIANT: {
                return bigDecimalVal;
            }
            case FLOAT: 
            case DOUBLE: {
                return bigDecimalVal.doubleValue();
            }
            case REAL: {
                return Float.valueOf(bigDecimalVal.floatValue());
            }
            case INTEGER: {
                return bigDecimalVal.intValue();
            }
            case TINYINT: 
            case SMALLINT: {
                return bigDecimalVal.shortValue();
            }
            case BIT: 
            case BOOLEAN: {
                return 0 != bigDecimalVal.compareTo(BigDecimal.valueOf(0L));
            }
            case BIGINT: {
                return bigDecimalVal.longValue();
            }
            case BINARY: {
                return SqlSerializerUtil.convertBigDecimalToBytes(bigDecimalVal, bigDecimalVal.scale());
            }
        }
        return bigDecimalVal.toString();
    }

    static final Object convertMoneyToObject(BigDecimal bigDecimalVal, JDBCType jdbcType, int numberOfBytes) {
        switch (jdbcType) {
            case NUMERIC: 
            case DECIMAL: 
            case SMALLMONEY: 
            case MONEY: {
                return bigDecimalVal;
            }
            case FLOAT: 
            case DOUBLE: {
                return bigDecimalVal.doubleValue();
            }
            case REAL: {
                return Float.valueOf(bigDecimalVal.floatValue());
            }
            case INTEGER: {
                return bigDecimalVal.intValue();
            }
            case TINYINT: 
            case SMALLINT: {
                return bigDecimalVal.shortValue();
            }
            case BIT: 
            case BOOLEAN: {
                return 0 != bigDecimalVal.compareTo(BigDecimal.valueOf(0L));
            }
            case BIGINT: {
                return bigDecimalVal.longValue();
            }
            case BINARY: {
                return SqlSerializerUtil.convertToBytes(bigDecimalVal, bigDecimalVal.scale(), numberOfBytes);
            }
        }
        return bigDecimalVal.toString();
    }

    private static byte[] convertToBytes(BigDecimal value, int scale, int numBytes) {
        boolean isNeg = value.signum() < 0;
        value = value.setScale(scale);
        BigInteger bigInt = value.unscaledValue();
        byte[] unscaledBytes = bigInt.toByteArray();
        byte[] ret = new byte[numBytes];
        if (unscaledBytes.length < numBytes) {
            for (int i = 0; i < numBytes - unscaledBytes.length; ++i) {
                ret[i] = (byte)(isNeg ? -1 : 0);
            }
        }
        int offset = numBytes - unscaledBytes.length;
        System.arraycopy(unscaledBytes, 0, ret, offset, numBytes - offset);
        return ret;
    }

    static final Object convertBytesToObject(byte[] bytesValue, JDBCType jdbcType, SSType ssType, int precision) throws MicrosoftDataEncryptionException {
        switch (jdbcType) {
            case CHAR: {
                String str = CryptographyExtensions.toHexString(bytesValue);
                if (SSType.BINARY == ssType && str.length() < precision * 2) {
                    StringBuilder strbuf = new StringBuilder(str);
                    while (strbuf.length() < precision * 2) {
                        strbuf.append('0');
                    }
                    return strbuf.toString();
                }
                return str;
            }
            case BINARY: 
            case VARBINARY: 
            case LONGVARBINARY: {
                if (SSType.BINARY == ssType && bytesValue.length < precision) {
                    byte[] newBytes = new byte[precision];
                    System.arraycopy(bytesValue, 0, newBytes, 0, bytesValue.length);
                    return newBytes;
                }
                return bytesValue;
            }
        }
        MessageFormat form = new MessageFormat("The conversion from {0} to {1} is unsupported.");
        Object[] msgArgs = new Object[]{jdbcType, ssType};
        throw new MicrosoftDataEncryptionException(form.format(msgArgs));
    }

    static final Object convertStringToObject(String stringVal, JDBCType jdbcType) throws UnsupportedEncodingException, IllegalArgumentException {
        switch (jdbcType) {
            case NUMERIC: 
            case DECIMAL: 
            case SMALLMONEY: 
            case MONEY: {
                return new BigDecimal(stringVal.trim());
            }
            case FLOAT: 
            case DOUBLE: {
                return Double.valueOf(stringVal.trim());
            }
            case REAL: {
                return Float.valueOf(stringVal.trim());
            }
            case INTEGER: {
                return Integer.valueOf(stringVal.trim());
            }
            case TINYINT: 
            case SMALLINT: {
                return Short.valueOf(stringVal.trim());
            }
            case BIT: 
            case BOOLEAN: {
                String trimmedString = stringVal.trim();
                return 1 == trimmedString.length() ? Boolean.valueOf('1' == trimmedString.charAt(0)) : Boolean.valueOf(trimmedString);
            }
            case BIGINT: {
                return Long.valueOf(stringVal.trim());
            }
            case TIMESTAMP: {
                return Timestamp.valueOf(stringVal.trim());
            }
            case LOCALDATETIME: {
                return SqlSerializerUtil.parseStringIntoLDT(stringVal.trim());
            }
            case DATE: {
                return Date.valueOf(SqlSerializerUtil.getDatePart(stringVal.trim()));
            }
            case TIME: {
                Timestamp ts = Timestamp.valueOf("1970-01-01 " + SqlSerializerUtil.getTimePart(stringVal.trim()));
                GregorianCalendar cal = new GregorianCalendar(Locale.US);
                cal.clear();
                cal.setTimeInMillis(ts.getTime());
                if (ts.getNanos() % 1000000 >= 500000) {
                    cal.add(14, 1);
                }
                cal.set(1970, 0, 1);
                return new Time(cal.getTimeInMillis());
            }
            case BINARY: {
                return stringVal.getBytes();
            }
        }
        return stringVal;
    }

    private static LocalDateTime parseStringIntoLDT(String s) {
        int second;
        int minute;
        int hour;
        int YEAR_LENGTH = 4;
        int MONTH_LENGTH = 2;
        int DAY_LENGTH = 2;
        int MAX_MONTH = 12;
        int MAX_DAY = 31;
        int year = 0;
        int month = 0;
        int day = 0;
        int a_nanos = 0;
        String formatError = MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidTimestampFormat");
        if (s == null) {
            throw new IllegalArgumentException(MicrosoftDataEncryptionExceptionResource.getResource("R_NullString"));
        }
        int dividingSpace = (s = s.trim()).indexOf(32);
        if (dividingSpace < 0) {
            throw new IllegalArgumentException(formatError);
        }
        int firstDash = s.indexOf(45);
        int secondDash = s.indexOf(45, firstDash + 1);
        int firstColon = s.indexOf(58, dividingSpace + 1);
        int secondColon = s.indexOf(58, firstColon + 1);
        int period = s.indexOf(46, secondColon + 1);
        boolean parsedDate = false;
        if (firstDash > 0 && secondDash > 0 && secondDash < dividingSpace - 1 && firstDash == 4 && secondDash - firstDash > 1 && secondDash - firstDash <= 3 && dividingSpace - secondDash > 1 && dividingSpace - secondDash <= 3) {
            year = Integer.parseInt(s.substring(0, firstDash));
            month = Integer.parseInt(s.substring(firstDash + 1, secondDash));
            day = Integer.parseInt(s.substring(secondDash + 1, dividingSpace));
            if (month >= 1 && month <= 12 && day >= 1 && day <= 31) {
                parsedDate = true;
            }
        }
        if (!parsedDate) {
            throw new IllegalArgumentException(formatError);
        }
        int len = s.length();
        if (firstColon > 0 && secondColon > 0 && secondColon < len - 1) {
            hour = Integer.parseInt(s.substring(dividingSpace + 1, firstColon));
            minute = Integer.parseInt(s.substring(firstColon + 1, secondColon));
            if (period > 0 && period < len - 1) {
                second = Integer.parseInt(s.substring(secondColon + 1, period));
                int nanoPrecision = len - (period + 1);
                if (nanoPrecision > 9) {
                    throw new IllegalArgumentException(formatError);
                }
                if (!Character.isDigit(s.charAt(period + 1))) {
                    throw new IllegalArgumentException(formatError);
                }
                int tmpNanos = Integer.parseInt(s.substring(period + 1, len));
                while (nanoPrecision < 9) {
                    tmpNanos *= 10;
                    ++nanoPrecision;
                }
                a_nanos = tmpNanos;
            } else {
                if (period > 0) {
                    throw new IllegalArgumentException(formatError);
                }
                second = Integer.parseInt(s.substring(secondColon + 1, len));
            }
        } else {
            throw new IllegalArgumentException(formatError);
        }
        return LocalDateTime.of(year, month, day, hour, minute, second, a_nanos);
    }

    private static String getDatePart(String s) {
        int sp = s.indexOf(32);
        if (-1 == sp) {
            return s;
        }
        return s.substring(0, sp);
    }

    private static String getTimePart(String s) {
        int sp = s.indexOf(32);
        if (-1 == sp) {
            return s;
        }
        return s.substring(sp + 1);
    }

    private static String fractionalSecondsString(long subSecondNanos, int scale) {
        assert (0L <= subSecondNanos && subSecondNanos < 1000000000L);
        assert (0 <= scale && scale <= 7);
        if (0 == scale) {
            return "";
        }
        return BigDecimal.valueOf(subSecondNanos % 1000000000L, 9).setScale(scale).toPlainString().substring(1);
    }

    static byte[] getNormalizedTemporal(GregorianCalendar cal, int subSecondNanos, int scale, SSType ssType, short minutesOffset) throws MicrosoftDataEncryptionException {
        byte[] encodedBytes;
        assert (SSType.DATE == ssType || SSType.TIME == ssType || SSType.DATETIME2 == ssType || SSType.DATETIMEOFFSET == ssType) : "Unexpected SSType: " + (Object)((Object)ssType);
        byte[] encodedBytesForEncryption = null;
        int secondsSinceMidnight = 0;
        long divisor = 0L;
        long scaledNanos = 0L;
        if (SSType.TIME == ssType || SSType.DATETIME2 == ssType || SSType.DATETIMEOFFSET == ssType) {
            assert (subSecondNanos >= 0);
            assert (subSecondNanos < 1000000000);
            assert (scale >= 0);
            assert (scale <= 7);
            secondsSinceMidnight = cal.get(13) + 60 * cal.get(12) + 3600 * cal.get(11);
            divisor = (long)Nanos.PER_MAX_SCALE_INTERVAL * (long)Math.pow(10.0, 7 - scale);
            scaledNanos = (1000000000L * (long)secondsSinceMidnight + (long)SqlSerializerUtil.getRoundedSubSecondNanos(subSecondNanos) + divisor / 2L) / divisor * divisor / 100L;
            if (SSType.TIME == ssType && 864000000000L <= scaledNanos) {
                scaledNanos = (1000000000L * (long)secondsSinceMidnight + (long)SqlSerializerUtil.getRoundedSubSecondNanos(subSecondNanos)) / divisor * divisor / 100L;
            }
            if (86400000000000L / divisor == scaledNanos) {
                if (SSType.TIME == ssType) {
                    --scaledNanos;
                } else {
                    assert (SSType.DATETIME2 == ssType || SSType.DATETIMEOFFSET == ssType) : "Unexpected SSType: " + (Object)((Object)ssType);
                    cal.add(13, 1);
                    if (cal.get(1) <= 9999) {
                        scaledNanos = 0L;
                    } else {
                        cal.add(13, -1);
                        --scaledNanos;
                    }
                }
            }
            int encodedLength = SqlSerializerUtil.nanosSinceMidnightLength(7);
            encodedBytes = SqlSerializerUtil.scaledNanosToEncodedBytes(scaledNanos, encodedLength);
            if (SSType.TIME == ssType) {
                return encodedBytes;
            }
            if (SSType.DATETIME2 == ssType) {
                encodedBytesForEncryption = new byte[encodedLength + 3];
                System.arraycopy(encodedBytes, 0, encodedBytesForEncryption, 0, encodedBytes.length);
            } else if (SSType.DATETIMEOFFSET == ssType) {
                encodedBytesForEncryption = new byte[encodedLength + 5];
                System.arraycopy(encodedBytes, 0, encodedBytesForEncryption, 0, encodedBytes.length);
            }
        }
        if (SSType.DATE == ssType || SSType.DATETIME2 == ssType || SSType.DATETIMEOFFSET == ssType) {
            int encodedLength;
            int daysIntoCE;
            if (cal.getTimeInMillis() < GregorianChange.STANDARD_CHANGE_DATE.getTime() || cal.getActualMaximum(6) < 365) {
                int year = cal.get(1);
                int month = cal.get(2);
                int date = cal.get(5);
                cal.setGregorianChange(GregorianChange.PURE_CHANGE_DATE);
                cal.set(year, month, date);
            }
            if ((daysIntoCE = SqlSerializerUtil.daysSinceBaseDate(cal.get(1), cal.get(6), 1)) < 0 || daysIntoCE >= SqlSerializerUtil.daysSinceBaseDate(10000, 1, 1)) {
                throw new MicrosoftDataEncryptionException(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidTemporalValue"));
            }
            encodedBytes = new byte[]{(byte)(daysIntoCE >> 0 & 0xFF), (byte)(daysIntoCE >> 8 & 0xFF), (byte)(daysIntoCE >> 16 & 0xFF)};
            if (SSType.DATE == ssType) {
                return encodedBytes;
            }
            if (SSType.DATETIME2 == ssType) {
                if (3652058 == daysIntoCE && 864000000000L == scaledNanos) {
                    scaledNanos = (1000000000L * (long)secondsSinceMidnight + (long)SqlSerializerUtil.getRoundedSubSecondNanos(subSecondNanos)) / divisor * divisor / 100L;
                    encodedLength = SqlSerializerUtil.nanosSinceMidnightLength(7);
                    byte[] encodedNanoBytes = SqlSerializerUtil.scaledNanosToEncodedBytes(scaledNanos, encodedLength);
                    encodedBytesForEncryption = new byte[encodedLength + 3];
                    System.arraycopy(encodedNanoBytes, 0, encodedBytesForEncryption, 0, encodedNanoBytes.length);
                }
                if (null != encodedBytesForEncryption) {
                    System.arraycopy(encodedBytes, 0, encodedBytesForEncryption, encodedBytesForEncryption.length - 3, 3);
                }
                return encodedBytesForEncryption;
            }
            if (3652058 == daysIntoCE && 864000000000L == scaledNanos) {
                scaledNanos = (1000000000L * (long)secondsSinceMidnight + (long)SqlSerializerUtil.getRoundedSubSecondNanos(subSecondNanos)) / divisor * divisor / 100L;
                encodedLength = SqlSerializerUtil.nanosSinceMidnightLength(7);
                byte[] encodedNanoBytes = SqlSerializerUtil.scaledNanosToEncodedBytes(scaledNanos, encodedLength);
                encodedBytesForEncryption = new byte[encodedLength + 5];
                System.arraycopy(encodedNanoBytes, 0, encodedBytesForEncryption, 0, encodedNanoBytes.length);
            }
            if (null != encodedBytesForEncryption) {
                System.arraycopy(encodedBytes, 0, encodedBytesForEncryption, encodedBytesForEncryption.length - 5, 3);
                System.arraycopy(ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(minutesOffset).array(), 0, encodedBytesForEncryption, encodedBytesForEncryption.length - 2, 2);
            }
            return encodedBytesForEncryption;
        }
        throw new MicrosoftDataEncryptionException(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidTemporalValue"));
    }

    static byte[] getNormalizedDateTimeAsBytes(GregorianCalendar cal, int subSecondNanos, JDBCType jdbcType) throws MicrosoftDataEncryptionException {
        int daysSinceSQLBaseDate = SqlSerializerUtil.daysSinceBaseDate(cal.get(1), cal.get(6), 1900);
        int millisSinceMidnight = (subSecondNanos + 500000) / 1000000 + 1000 * cal.get(13) + 60000 * cal.get(12) + 3600000 * cal.get(11);
        if (millisSinceMidnight >= 86399999) {
            ++daysSinceSQLBaseDate;
            millisSinceMidnight = 0;
        }
        if (JDBCType.SMALLDATETIME == jdbcType) {
            int secondsSinceMidnight = millisSinceMidnight / 1000;
            int minutesSinceMidnight = secondsSinceMidnight / 60;
            minutesSinceMidnight = (double)(secondsSinceMidnight % 60) > 29.998 ? minutesSinceMidnight + 1 : minutesSinceMidnight;
            int maxMinutesSinceMidnight_SmallDateTime = 1440;
            if (daysSinceSQLBaseDate < SqlSerializerUtil.daysSinceBaseDate(1900, 1, 1900) || daysSinceSQLBaseDate > SqlSerializerUtil.daysSinceBaseDate(2079, 157, 1900) || daysSinceSQLBaseDate == SqlSerializerUtil.daysSinceBaseDate(2079, 157, 1900) && minutesSinceMidnight >= maxMinutesSinceMidnight_SmallDateTime) {
                throw new MicrosoftDataEncryptionException(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidTemporalValue"));
            }
            ByteBuffer days = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
            days.putShort((short)daysSinceSQLBaseDate);
            ByteBuffer seconds = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
            seconds.putShort((short)minutesSinceMidnight);
            byte[] value = new byte[4];
            System.arraycopy(days.array(), 0, value, 0, 2);
            System.arraycopy(seconds.array(), 0, value, 2, 2);
            return value;
        }
        if (JDBCType.DATETIME == jdbcType) {
            if (daysSinceSQLBaseDate < SqlSerializerUtil.daysSinceBaseDate(1753, 1, 1900) || daysSinceSQLBaseDate >= SqlSerializerUtil.daysSinceBaseDate(10000, 1, 1900)) {
                throw new MicrosoftDataEncryptionException(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidTemporalValue"));
            }
            ByteBuffer days = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            days.putInt(daysSinceSQLBaseDate);
            ByteBuffer seconds = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            seconds.putInt((3 * millisSinceMidnight + 5) / 10);
            byte[] value = new byte[8];
            System.arraycopy(days.array(), 0, value, 0, 4);
            System.arraycopy(seconds.array(), 0, value, 4, 4);
            return value;
        }
        assert (false) : "Unexpected JDBCType type " + (Object)((Object)jdbcType);
        return null;
    }

    private static int getRoundedSubSecondNanos(int subSecondNanos) {
        int roundedNanos = (subSecondNanos + Nanos.PER_MAX_SCALE_INTERVAL / 2) / Nanos.PER_MAX_SCALE_INTERVAL * Nanos.PER_MAX_SCALE_INTERVAL;
        return roundedNanos;
    }

    private static int nanosSinceMidnightLength(int scale) {
        int[] scaledLengths = new int[]{3, 3, 3, 4, 4, 5, 5, 5};
        assert (scale >= 0);
        assert (scale <= 7);
        return scaledLengths[scale];
    }

    private static byte[] scaledNanosToEncodedBytes(long scaledNanos, int encodedLength) {
        byte[] encodedBytes = new byte[encodedLength];
        for (int i = 0; i < encodedLength; ++i) {
            encodedBytes[i] = (byte)(scaledNanos >> 8 * i & 0xFFL);
        }
        return encodedBytes;
    }

    static final Object convertTemporalToObject(JDBCType jdbcType, SSType ssType, Calendar timeZoneCalendar, int daysSinceBaseDate, long ticksSinceMidnight, int fractionalSecondsScale) throws MicrosoftDataEncryptionException {
        int subSecondNanos;
        if (null == timeZoneCalendar) {
            return SqlSerializerUtil.convertTemporalToObject(jdbcType, ssType, daysSinceBaseDate, ticksSinceMidnight, fractionalSecondsScale);
        }
        TimeZone localTimeZone = timeZoneCalendar.getTimeZone();
        TimeZone componentTimeZone = SSType.DATETIMEOFFSET == ssType ? UTC.timeZone : localTimeZone;
        GregorianCalendar cal = new GregorianCalendar(componentTimeZone, Locale.US);
        cal.setLenient(true);
        cal.clear();
        switch (ssType) {
            case TIME: {
                cal.set(1900, 0, 1, 0, 0, 0);
                cal.set(14, (int)(ticksSinceMidnight / 1000000L));
                subSecondNanos = (int)(ticksSinceMidnight % 1000000000L);
                break;
            }
            case DATE: 
            case DATETIME2: 
            case DATETIMEOFFSET: {
                if (daysSinceBaseDate >= GregorianChange.DAYS_SINCE_BASE_DATE_HINT) {
                    cal.set(1, 0, 1 + daysSinceBaseDate + GregorianChange.EXTRA_DAYS_TO_BE_ADDED, 0, 0, 0);
                    cal.set(14, (int)(ticksSinceMidnight / 1000000L));
                } else {
                    cal.setGregorianChange(GregorianChange.PURE_CHANGE_DATE);
                    cal.set(1, 0, 1 + daysSinceBaseDate, 0, 0, 0);
                    cal.set(14, (int)(ticksSinceMidnight / 1000000L));
                    int year = cal.get(1);
                    int month = cal.get(2);
                    int date = cal.get(5);
                    int hour = cal.get(11);
                    int minute = cal.get(12);
                    int second = cal.get(13);
                    int millis = cal.get(14);
                    cal.setGregorianChange(GregorianChange.STANDARD_CHANGE_DATE);
                    cal.set(year, month, date, hour, minute, second);
                    cal.set(14, millis);
                }
                if (SSType.DATETIMEOFFSET == ssType && !componentTimeZone.hasSameRules(localTimeZone)) {
                    GregorianCalendar localCalendar = new GregorianCalendar(localTimeZone, Locale.US);
                    localCalendar.clear();
                    localCalendar.setTimeInMillis(cal.getTimeInMillis());
                    cal = localCalendar;
                }
                subSecondNanos = (int)(ticksSinceMidnight % 1000000000L);
                break;
            }
            case DATETIME: {
                cal.set(1900, 0, 1 + daysSinceBaseDate, 0, 0, 0);
                cal.set(14, (int)ticksSinceMidnight);
                subSecondNanos = (int)(ticksSinceMidnight * 1000000L % 1000000000L);
                break;
            }
            default: {
                MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_UnexpectedSourceType"));
                Object[] msgArgs = new Object[]{ssType};
                throw new MicrosoftDataEncryptionException(form.format(msgArgs));
            }
        }
        int localMillisOffset = timeZoneCalendar.get(15);
        switch (jdbcType.category) {
            case BINARY: 
            case SQL_VARIANT: {
                switch (ssType) {
                    case DATE: {
                        cal.set(11, 0);
                        cal.set(12, 0);
                        cal.set(13, 0);
                        cal.set(14, 0);
                        return new Date(cal.getTimeInMillis());
                    }
                    case DATETIME2: 
                    case DATETIME: {
                        Timestamp ts = new Timestamp(cal.getTimeInMillis());
                        ts.setNanos(subSecondNanos);
                        return ts;
                    }
                    case DATETIMEOFFSET: {
                        assert (SSType.DATETIMEOFFSET == ssType);
                        assert (0 == localMillisOffset % 60000);
                        Timestamp ts = new Timestamp(cal.getTimeInMillis());
                        ts.setNanos(subSecondNanos);
                        return DateTimeOffset.valueOf(ts, localMillisOffset / 60000);
                    }
                    case TIME: {
                        if (subSecondNanos % 1000000 >= 500000) {
                            cal.add(14, 1);
                        }
                        cal.set(1970, 0, 1);
                        return new Time(cal.getTimeInMillis());
                    }
                }
                MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_UnexpectedSourceType"));
                Object[] msgArgs = new Object[]{ssType};
                throw new MicrosoftDataEncryptionException(form.format(msgArgs));
            }
            case DATE: {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                return new Date(cal.getTimeInMillis());
            }
            case TIME: {
                if (subSecondNanos % 1000000 >= 500000) {
                    cal.add(14, 1);
                }
                cal.set(1970, 0, 1);
                return new Time(cal.getTimeInMillis());
            }
            case TIMESTAMP: {
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ts.setNanos(subSecondNanos);
                if (jdbcType == JDBCType.LOCALDATETIME) {
                    return ts.toLocalDateTime();
                }
                return ts;
            }
            case DATETIMEOFFSET: {
                assert (SSType.DATETIMEOFFSET == ssType);
                assert (0 == localMillisOffset % 60000);
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ts.setNanos(subSecondNanos);
                return DateTimeOffset.valueOf(ts, localMillisOffset / 60000);
            }
            case CHARACTER: {
                switch (ssType) {
                    case DATE: {
                        return String.format(Locale.US, "%1$tF", cal);
                    }
                    case TIME: {
                        return String.format(Locale.US, "%1$tT%2$s", cal, SqlSerializerUtil.fractionalSecondsString(subSecondNanos, fractionalSecondsScale));
                    }
                    case DATETIME2: {
                        return String.format(Locale.US, "%1$tF %1$tT%2$s", cal, SqlSerializerUtil.fractionalSecondsString(subSecondNanos, fractionalSecondsScale));
                    }
                    case DATETIMEOFFSET: {
                        assert (0 == localMillisOffset % 60000);
                        int unsignedMinutesOffset = Math.abs(localMillisOffset / 60000);
                        return String.format(Locale.US, "%1$tF %1$tT%2$s %3$c%4$02d:%5$02d", cal, SqlSerializerUtil.fractionalSecondsString(subSecondNanos, fractionalSecondsScale), Character.valueOf(localMillisOffset >= 0 ? (char)'+' : '-'), unsignedMinutesOffset / 60, unsignedMinutesOffset % 60);
                    }
                    case DATETIME: {
                        return new Timestamp(cal.getTimeInMillis()).toString();
                    }
                }
                MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_UnexpectedSourceType"));
                Object[] msgArgs = new Object[]{ssType};
                throw new MicrosoftDataEncryptionException(form.format(msgArgs));
            }
        }
        MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_UnexpectedTargetType"));
        Object[] msgArgs = new Object[]{jdbcType};
        throw new MicrosoftDataEncryptionException(form.format(msgArgs));
    }

    private static Object convertTemporalToObject(JDBCType jdbcType, SSType ssType, int daysSinceBaseDate, long ticksSinceMidnight, int fractionalSecondsScale) throws MicrosoftDataEncryptionException {
        int subSecondNanos;
        LocalDateTime ldt = null;
        switch (ssType) {
            case TIME: {
                ldt = LocalDateTime.of(1900, 1, 1, 0, 0, 0).plusNanos(ticksSinceMidnight);
                subSecondNanos = (int)(ticksSinceMidnight % 1000000000L);
                break;
            }
            case DATE: 
            case DATETIME2: 
            case DATETIMEOFFSET: {
                ldt = LocalDateTime.of(1, 1, 1, 0, 0, 0);
                ldt = ldt.plusDays(daysSinceBaseDate);
                if (jdbcType.category != JDBCType.Category.DATE) {
                    ldt = ldt.plusNanos(ticksSinceMidnight);
                }
                subSecondNanos = (int)(ticksSinceMidnight % 1000000000L);
                break;
            }
            case DATETIME: {
                ldt = LocalDateTime.of(1900, 1, 1, 0, 0, 0);
                ldt = ldt.plusDays(daysSinceBaseDate);
                if (jdbcType.category != JDBCType.Category.DATE) {
                    ldt = ldt.plusNanos(ticksSinceMidnight * 1000000L);
                }
                subSecondNanos = (int)(ticksSinceMidnight * 1000000L % 1000000000L);
                break;
            }
            default: {
                MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_UnexpectedSourceType"));
                Object[] msgArgs = new Object[]{ssType};
                throw new MicrosoftDataEncryptionException(form.format(msgArgs));
            }
        }
        switch (jdbcType.category) {
            case BINARY: 
            case SQL_VARIANT: {
                switch (ssType) {
                    case DATE: {
                        return Date.valueOf(ldt.toLocalDate());
                    }
                    case DATETIME2: 
                    case DATETIME: {
                        Timestamp ts = Timestamp.valueOf(ldt);
                        ts.setNanos(subSecondNanos);
                        return ts;
                    }
                    case TIME: {
                        if (subSecondNanos % 1000000 >= 500000) {
                            ldt = ldt.plusNanos(1000000L);
                        }
                        Time t = Time.valueOf(ldt.toLocalTime());
                        t.setTime(t.getTime() + (long)(ldt.getNano() / 1000000));
                        return t;
                    }
                }
                MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_UnexpectedSourceType"));
                Object[] msgArgs = new Object[]{ssType};
                throw new MicrosoftDataEncryptionException(form.format(msgArgs));
            }
            case DATE: {
                return Date.valueOf(ldt.toLocalDate());
            }
            case TIME: {
                if (subSecondNanos % 1000000 >= 500000) {
                    ldt = ldt.plusNanos(1000000L);
                }
                Time t = Time.valueOf(ldt.toLocalTime());
                t.setTime(t.getTime() + (long)(ldt.getNano() / 1000000));
                return t;
            }
            case TIMESTAMP: {
                if (jdbcType == JDBCType.LOCALDATETIME) {
                    return ldt;
                }
                Timestamp ts = Timestamp.valueOf(ldt);
                ts.setNanos(subSecondNanos);
                return ts;
            }
            case CHARACTER: {
                switch (ssType) {
                    case DATE: {
                        return String.format(Locale.US, "%1$tF", Timestamp.valueOf(ldt));
                    }
                    case TIME: {
                        return String.format(Locale.US, "%1$tT%2$s", ldt, SqlSerializerUtil.fractionalSecondsString(subSecondNanos, fractionalSecondsScale));
                    }
                    case DATETIME2: {
                        return String.format(Locale.US, "%1$tF %1$tT%2$s", Timestamp.valueOf(ldt), SqlSerializerUtil.fractionalSecondsString(subSecondNanos, fractionalSecondsScale));
                    }
                    case DATETIME: {
                        return Timestamp.valueOf(ldt).toString();
                    }
                }
                MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_UnexpectedSourceType"));
                Object[] msgArgs = new Object[]{ssType};
                throw new MicrosoftDataEncryptionException(form.format(msgArgs));
            }
        }
        MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_UnexpectedTargetType"));
        Object[] msgArgs = new Object[]{jdbcType};
        throw new MicrosoftDataEncryptionException(form.format(msgArgs));
    }

    private static int daysSinceBaseDate(int year, int dayOfYear, int baseYear) {
        assert (year >= 1);
        assert (baseYear >= 1);
        assert (dayOfYear >= 1);
        return dayOfYear - 1 + (year - baseYear) * 365 + SqlSerializerUtil.leapDaysBeforeYear(year) - SqlSerializerUtil.leapDaysBeforeYear(baseYear);
    }

    private static int leapDaysBeforeYear(int year) {
        assert (year >= 1);
        return (year - 1) / 4 - (year - 1) / 100 + (year - 1) / 400;
    }

    static final boolean exceedsMaxRPCDecimalPrecisionOrScale(BigDecimal bigDecimalValue) {
        BigInteger bi;
        if (null == bigDecimalValue) {
            return false;
        }
        if (bigDecimalValue.scale() > 38) {
            return true;
        }
        BigInteger bigInteger = bi = bigDecimalValue.scale() < 0 ? bigDecimalValue.setScale(0).unscaledValue() : bigDecimalValue.unscaledValue();
        if (bigDecimalValue.signum() < 0) {
            bi = bi.negate();
        }
        return bi.compareTo(maxRPCDecimalValue) > 0;
    }

    static final boolean isCharType(int jdbcType) {
        switch (jdbcType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    static final Boolean isCharType(SSType ssType) {
        switch (ssType) {
            case CHAR: 
            case VARCHAR: 
            case NCHAR: 
            case NVARCHAR: 
            case VARCHARMAX: 
            case NVARCHARMAX: {
                return true;
            }
        }
        return false;
    }

    static final Boolean isBinaryType(SSType ssType) {
        switch (ssType) {
            case BINARY: 
            case VARBINARY: 
            case VARBINARYMAX: 
            case IMAGE: {
                return true;
            }
        }
        return false;
    }

    static final Boolean isBinaryType(int jdbcType) {
        switch (jdbcType) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    static short readShort(byte[] data, int nOffset) {
        return (short)(data[nOffset] & 0xFF | (data[nOffset + 1] & 0xFF) << 8);
    }

    static int readUnsignedShort(byte[] data, int nOffset) {
        return data[nOffset] & 0xFF | (data[nOffset + 1] & 0xFF) << 8;
    }

    static int readUnsignedShortBigEndian(byte[] data, int nOffset) {
        return (data[nOffset] & 0xFF) << 8 | data[nOffset + 1] & 0xFF;
    }

    static void writeShort(short value, byte[] valueBytes, int offset) {
        valueBytes[offset + 0] = (byte)(value >> 0 & 0xFF);
        valueBytes[offset + 1] = (byte)(value >> 8 & 0xFF);
    }

    static void writeShortBigEndian(short value, byte[] valueBytes, int offset) {
        valueBytes[offset + 0] = (byte)(value >> 8 & 0xFF);
        valueBytes[offset + 1] = (byte)(value >> 0 & 0xFF);
    }

    static int readInt(byte[] data, int nOffset) {
        int b1 = data[nOffset + 0] & 0xFF;
        int b2 = (data[nOffset + 1] & 0xFF) << 8;
        int b3 = (data[nOffset + 2] & 0xFF) << 16;
        int b4 = (data[nOffset + 3] & 0xFF) << 24;
        return b4 | b3 | b2 | b1;
    }

    static int readIntBigEndian(byte[] data, int nOffset) {
        return (data[nOffset + 3] & 0xFF) << 0 | (data[nOffset + 2] & 0xFF) << 8 | (data[nOffset + 1] & 0xFF) << 16 | (data[nOffset + 0] & 0xFF) << 24;
    }

    static void writeInt(int value, byte[] valueBytes, int offset) {
        valueBytes[offset + 0] = (byte)(value >> 0 & 0xFF);
        valueBytes[offset + 1] = (byte)(value >> 8 & 0xFF);
        valueBytes[offset + 2] = (byte)(value >> 16 & 0xFF);
        valueBytes[offset + 3] = (byte)(value >> 24 & 0xFF);
    }

    static void writeIntBigEndian(int value, byte[] valueBytes, int offset) {
        valueBytes[offset + 0] = (byte)(value >> 24 & 0xFF);
        valueBytes[offset + 1] = (byte)(value >> 16 & 0xFF);
        valueBytes[offset + 2] = (byte)(value >> 8 & 0xFF);
        valueBytes[offset + 3] = (byte)(value >> 0 & 0xFF);
    }

    static void writeLongBigEndian(long value, byte[] valueBytes, int offset) {
        valueBytes[offset + 0] = (byte)(value >> 56 & 0xFFL);
        valueBytes[offset + 1] = (byte)(value >> 48 & 0xFFL);
        valueBytes[offset + 2] = (byte)(value >> 40 & 0xFFL);
        valueBytes[offset + 3] = (byte)(value >> 32 & 0xFFL);
        valueBytes[offset + 4] = (byte)(value >> 24 & 0xFFL);
        valueBytes[offset + 5] = (byte)(value >> 16 & 0xFFL);
        valueBytes[offset + 6] = (byte)(value >> 8 & 0xFFL);
        valueBytes[offset + 7] = (byte)(value >> 0 & 0xFFL);
    }

    static BigDecimal readBigDecimal(byte[] valueBytes, int valueLength, int scale) {
        int sign = 0 == valueBytes[0] ? -1 : 1;
        byte[] magnitude = new byte[valueLength - 1];
        for (int i = 1; i <= magnitude.length; ++i) {
            magnitude[magnitude.length - i] = valueBytes[i];
        }
        return new BigDecimal(new BigInteger(sign, magnitude), scale);
    }

    static long readLong(byte[] data, int nOffset) {
        return (long)(data[nOffset + 7] & 0xFF) << 56 | (long)(data[nOffset + 6] & 0xFF) << 48 | (long)(data[nOffset + 5] & 0xFF) << 40 | (long)(data[nOffset + 4] & 0xFF) << 32 | (long)(data[nOffset + 3] & 0xFF) << 24 | (long)(data[nOffset + 2] & 0xFF) << 16 | (long)(data[nOffset + 1] & 0xFF) << 8 | (long)(data[nOffset] & 0xFF);
    }

    static void writeLong(long value, byte[] valueBytes, int offset) {
        valueBytes[offset++] = (byte)(value & 0xFFL);
        valueBytes[offset++] = (byte)(value >> 8 & 0xFFL);
        valueBytes[offset++] = (byte)(value >> 16 & 0xFFL);
        valueBytes[offset++] = (byte)(value >> 24 & 0xFFL);
        valueBytes[offset++] = (byte)(value >> 32 & 0xFFL);
        valueBytes[offset++] = (byte)(value >> 40 & 0xFFL);
        valueBytes[offset++] = (byte)(value >> 48 & 0xFFL);
        valueBytes[offset] = (byte)(value >> 56 & 0xFFL);
    }

    static final String readGUID(byte[] inputGUID) throws MicrosoftDataEncryptionException {
        int i;
        String guidTemplate = "NNNNNNNN-NNNN-NNNN-NNNN-NNNNNNNNNNNN";
        byte[] guid = inputGUID;
        StringBuilder sb = new StringBuilder(guidTemplate.length());
        for (i = 0; i < 4; ++i) {
            sb.append(hexChars[(guid[3 - i] & 0xF0) >> 4]);
            sb.append(hexChars[guid[3 - i] & 0xF]);
        }
        sb.append('-');
        for (i = 0; i < 2; ++i) {
            sb.append(hexChars[(guid[5 - i] & 0xF0) >> 4]);
            sb.append(hexChars[guid[5 - i] & 0xF]);
        }
        sb.append('-');
        for (i = 0; i < 2; ++i) {
            sb.append(hexChars[(guid[7 - i] & 0xF0) >> 4]);
            sb.append(hexChars[guid[7 - i] & 0xF]);
        }
        sb.append('-');
        for (i = 0; i < 2; ++i) {
            sb.append(hexChars[(guid[8 + i] & 0xF0) >> 4]);
            sb.append(hexChars[guid[8 + i] & 0xF]);
        }
        sb.append('-');
        for (i = 0; i < 6; ++i) {
            sb.append(hexChars[(guid[10 + i] & 0xF0) >> 4]);
            sb.append(hexChars[guid[10 + i] & 0xF]);
        }
        return sb.toString();
    }

    static final byte[] asGuidByteArray(UUID aId) {
        long msb = aId.getMostSignificantBits();
        long lsb = aId.getLeastSignificantBits();
        byte[] buffer = new byte[16];
        SqlSerializerUtil.writeLongBigEndian(msb, buffer, 0);
        SqlSerializerUtil.writeLongBigEndian(lsb, buffer, 8);
        byte tmpByte = buffer[0];
        buffer[0] = buffer[3];
        buffer[3] = tmpByte;
        tmpByte = buffer[1];
        buffer[1] = buffer[2];
        buffer[2] = tmpByte;
        tmpByte = buffer[4];
        buffer[4] = buffer[5];
        buffer[5] = tmpByte;
        tmpByte = buffer[6];
        buffer[6] = buffer[7];
        buffer[7] = tmpByte;
        return buffer;
    }

    private static long readNanosSinceMidnightAE(byte[] value, int scale, SSType baseSSType) throws MicrosoftDataEncryptionException {
        long hundredNanosSinceMidnight = 0L;
        for (int i = 0; i < value.length; ++i) {
            hundredNanosSinceMidnight |= ((long)value[i] & 0xFFL) << 8 * i;
        }
        if (0L > hundredNanosSinceMidnight || hundredNanosSinceMidnight >= 864000000000L) {
            throw new MicrosoftDataEncryptionException(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidTemporalValue"));
        }
        return 100L * hundredNanosSinceMidnight;
    }

    private static int getDaysIntoCE(byte[] datePortion, SSType baseSSType) throws MicrosoftDataEncryptionException {
        int daysIntoCE = 0;
        for (int i = 0; i < datePortion.length; ++i) {
            daysIntoCE |= (datePortion[i] & 0xFF) << 8 * i;
        }
        if (daysIntoCE < 0) {
            throw new MicrosoftDataEncryptionException(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidTemporalValue"));
        }
        return daysIntoCE;
    }

    static void validateMoneyRange(BigDecimal bd, JDBCType jdbcType) throws MicrosoftDataEncryptionException {
        if (null == bd) {
            return;
        }
        switch (jdbcType) {
            case MONEY: {
                if (1 == bd.compareTo(SSType.MAX_VALUE_MONEY) || -1 == bd.compareTo(SSType.MIN_VALUE_MONEY)) break;
                return;
            }
            case SMALLMONEY: {
                if (1 == bd.compareTo(SSType.MAX_VALUE_SMALLMONEY) || -1 == bd.compareTo(SSType.MIN_VALUE_SMALLMONEY)) break;
                return;
            }
        }
        MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_valueOutOfRange"));
        Object[] msgArgs = new Object[]{jdbcType};
        throw new MicrosoftDataEncryptionException(form.format(msgArgs));
    }
}

