/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.ISerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionExceptionResource;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.Serializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SerializerFactory;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlBigIntSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlBinarySerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlBooleanSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlCharSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlDateSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlDatetime2Serializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlDatetimeSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlDatetimeoffsetSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlDecimalSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlFloatSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlIntegerSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlMoneySerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlNcharSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlNumericSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlNvarcharSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlRealSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlSmalldatetimeSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlSmallintSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlSmallmoneySerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlTimeSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlTinyintSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlUniqueidentifierSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlVarbinarySerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlVarcharSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.Type;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.Utils;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SqlSerializerFactory
extends SerializerFactory {
    public static final String BIGINT_ID = "bigint";
    public static final String BINARY_ID = "binary";
    public static final String BIT_ID = "bit";
    public static final String CHAR_ID = "char";
    public static final String DATE_ID = "date";
    public static final String DATETIME2_ID = "datetime2";
    public static final String DATETIMEOFFSET_ID = "datetimeoffset";
    public static final String DATETIME_ID = "datetime";
    public static final String DECIMAL_ID = "decimal";
    public static final String NUMERIC_ID = "numeric";
    public static final String FLOAT_ID = "float";
    public static final String INTEGER_ID = "integer";
    public static final String MONEY_ID = "money";
    public static final String NCHAR_ID = "nchar";
    public static final String NVARCHAR_ID = "nvarchar";
    public static final String REAL_ID = "real";
    public static final String SMALLDATETIME_ID = "smalldatetime";
    public static final String SMALLINT_ID = "smallint";
    public static final String SMALLMONEY_ID = "smallmoney";
    public static final String TIME_ID = "time";
    public static final String TINYINT_ID = "tinyint";
    public static final String UNIQUEIDENTIFIER_ID = "uniqueidentifier";
    public static final String VARBINARY_ID = "varbinary";
    public static final String VARCHAR_ID = "varchar";
    private Map<String, ISerializer> serializerByIdentifier = new ConcurrentHashMap<String, ISerializer>();
    private Map<Type, ISerializer> serializerByType = new ConcurrentHashMap<Type, ISerializer>();
    private static Map<Type, ISerializer> serializerCache = new ConcurrentHashMap<Type, ISerializer>();

    public SqlSerializerFactory() throws MicrosoftDataEncryptionException {
        this.initialize();
    }

    @Override
    public ISerializer getSerializer(String id) throws MicrosoftDataEncryptionException {
        Utils.validateNotNull(id, "Serializer id");
        return this.serializerByIdentifier.get(id);
    }

    public static ISerializer getOrCreate(String id, int size, int precision, int scale) throws MicrosoftDataEncryptionException {
        return SqlSerializerFactory.getOrCreate(id, size, precision, scale, null);
    }

    public static ISerializer getOrCreate(String id, int size, int precision, int scale, String codepage) throws MicrosoftDataEncryptionException {
        ISerializer s = serializerCache.get(new Type(id, size, precision, scale, codepage));
        if (null == s) {
            s = SqlSerializerFactory.createSerializer(id, size, precision, scale, true, codepage);
        }
        return s;
    }

    private static ISerializer createSerializer(String id, int size, int precision, int scale, boolean isByType, String codepage) throws MicrosoftDataEncryptionException {
        SqlSerializer s = null;
        switch (id.toLowerCase()) {
            case "bigint": {
                s = new SqlBigIntSerializer(size, precision, scale);
                break;
            }
            case "binary": {
                s = new SqlBinarySerializer(size, precision, scale);
                break;
            }
            case "bit": {
                s = new SqlBooleanSerializer(size, precision, scale);
                break;
            }
            case "char": {
                s = new SqlCharSerializer(size, precision, scale);
                ((SqlCharSerializer)s).setCodepage(codepage);
                break;
            }
            case "date": {
                s = new SqlDateSerializer(size, precision, scale);
                break;
            }
            case "datetime2": {
                s = new SqlDatetime2Serializer(size, precision, scale);
                break;
            }
            case "datetimeoffset": {
                s = new SqlDatetimeoffsetSerializer(size, precision, scale);
                break;
            }
            case "datetime": {
                s = new SqlDatetimeSerializer(size, precision, scale);
                break;
            }
            case "decimal": {
                s = new SqlDecimalSerializer(size, precision, scale);
                break;
            }
            case "numeric": {
                s = new SqlNumericSerializer(size, precision, scale);
                break;
            }
            case "float": {
                s = new SqlFloatSerializer(size, precision, scale);
                break;
            }
            case "integer": {
                s = new SqlIntegerSerializer(size, precision, scale);
                break;
            }
            case "money": {
                s = new SqlMoneySerializer(size, precision, scale);
                break;
            }
            case "nchar": {
                s = new SqlNcharSerializer(size, precision, scale);
                ((SqlNcharSerializer)s).setCodepage(codepage);
                break;
            }
            case "nvarchar": {
                s = new SqlNvarcharSerializer(size, precision, scale);
                ((SqlNvarcharSerializer)s).setCodepage(codepage);
                break;
            }
            case "real": {
                s = new SqlRealSerializer(size, precision, scale);
                break;
            }
            case "smalldatetime": {
                s = new SqlSmalldatetimeSerializer(size, precision, scale);
                break;
            }
            case "smallint": {
                s = new SqlSmallintSerializer(size, precision, scale);
                break;
            }
            case "smallmoney": {
                s = new SqlSmallmoneySerializer(size, precision, scale);
                break;
            }
            case "time": {
                s = new SqlTimeSerializer(size, precision, scale);
                break;
            }
            case "tinyint": {
                s = new SqlTinyintSerializer(size, precision, scale);
                break;
            }
            case "uniqueidentifier": {
                s = new SqlUniqueidentifierSerializer(size, precision, scale);
                break;
            }
            case "varbinary": {
                s = new SqlVarbinarySerializer(size, precision, scale);
                break;
            }
            case "varchar": {
                s = new SqlVarcharSerializer(size, precision, scale);
                ((SqlVarcharSerializer)s).setCodepage(codepage);
                break;
            }
            default: {
                MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidSerializerName"));
                Object[] msgArgs = new Object[]{id.toLowerCase()};
                throw new MicrosoftDataEncryptionException(form.format(msgArgs));
            }
        }
        serializerCache.put(new Type(id, size, precision, scale, codepage), s);
        return s;
    }

    private Serializer<?> createSerializer(String id) throws MicrosoftDataEncryptionException {
        SqlSerializer s = null;
        switch (id) {
            case "java.lang.Boolean": {
                s = new SqlBooleanSerializer(0, 0, 0);
                break;
            }
            case "java.lang.Integer": {
                s = new SqlIntegerSerializer(0, 0, 0);
                break;
            }
            case "java.lang.Long": {
                s = new SqlBigIntSerializer(0, 0, 0);
                break;
            }
            case "java.lang.Byte": {
                s = new SqlBinarySerializer(0, 0, 0);
                break;
            }
            case "java.lang.Double": {
                s = new SqlFloatSerializer(0, 0, 0);
                break;
            }
            case "java.lang.Float": {
                s = new SqlRealSerializer(0, 0, 0);
                break;
            }
            case "java.lang.String": {
                s = new SqlVarcharSerializer(0, 0, 0);
                break;
            }
            case "java.lang.Character": {
                s = new SqlCharSerializer(0, 0, 0);
                break;
            }
            case "java.util.UUID": {
                s = new SqlUniqueidentifierSerializer(0, 0, 0);
                break;
            }
            case "java.util.Date": {
                s = new SqlDateSerializer(0, 0, 0);
                break;
            }
            default: {
                MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_InvalidSerializerName"));
                Object[] msgArgs = new Object[]{id.toLowerCase()};
                throw new MicrosoftDataEncryptionException(form.format(msgArgs));
            }
        }
        this.serializerByIdentifier.put(id, s);
        return s;
    }

    @Override
    public <T> ISerializer getDefaultSerializer(Class<?> clazz) throws MicrosoftDataEncryptionException {
        Serializer<?> s = this.serializerByIdentifier.get(clazz.getName());
        if (null == s) {
            s = this.createSerializer(clazz.getName());
        }
        return s;
    }

    @Override
    public void registerSerializer(Type type, ISerializer sqlSerializer, boolean overrideDefault) {
        this.serializerByIdentifier.put(type.getId(), sqlSerializer);
        if (overrideDefault || !this.hasDefaultSqlSerializer(type)) {
            this.serializerByType.put(type, sqlSerializer);
        }
    }

    private void initialize() throws MicrosoftDataEncryptionException {
        this.registerDefaultSqlSerializers();
    }

    private void registerDefaultSqlSerializers() throws MicrosoftDataEncryptionException {
        this.registerSerializer(new Type(BIGINT_ID, 0, 0, 0, null), new SqlBigIntSerializer(0, 0, 0), false);
        this.registerSerializer(new Type(BINARY_ID, 0, 0, 0, null), new SqlBinarySerializer(0, 0, 0), false);
        this.registerSerializer(new Type(BIT_ID, 0, 0, 0, null), new SqlBooleanSerializer(0, 0, 0), false);
        this.registerSerializer(new Type(CHAR_ID, 0, 0, 0, null), new SqlCharSerializer(0, 0, 0), false);
        this.registerSerializer(new Type(DATE_ID, 0, 0, 0, null), new SqlDateSerializer(0, 0, 0), false);
        this.registerSerializer(new Type(DATETIME2_ID, 0, 0, 0, null), new SqlDatetime2Serializer(0, 0, 0), false);
        this.registerSerializer(new Type(DATETIMEOFFSET_ID, 0, 0, 0, null), new SqlDatetimeoffsetSerializer(0, 0, 0), false);
        this.registerSerializer(new Type(DATETIME_ID, 0, 0, 0, null), new SqlDatetimeSerializer(0, 0, 0), false);
        this.registerSerializer(new Type(DECIMAL_ID, 0, 0, 0, null), new SqlDecimalSerializer(0, 0, 0), false);
        this.registerSerializer(new Type(NUMERIC_ID, 0, 0, 0, null), new SqlNumericSerializer(0, 0, 0), false);
        this.registerSerializer(new Type(FLOAT_ID, 0, 0, 0, null), new SqlFloatSerializer(0, 0, 0), false);
        this.registerSerializer(new Type(INTEGER_ID, 0, 0, 0, null), new SqlIntegerSerializer(0, 0, 0), false);
        this.registerSerializer(new Type(MONEY_ID, 0, 0, 0, null), new SqlMoneySerializer(0, 0, 0), false);
        this.registerSerializer(new Type(NCHAR_ID, 0, 0, 0, null), new SqlNcharSerializer(0, 0, 0), false);
        this.registerSerializer(new Type(NVARCHAR_ID, 0, 0, 0, null), new SqlNvarcharSerializer(0, 0, 0), false);
        this.registerSerializer(new Type(REAL_ID, 0, 0, 0, null), new SqlRealSerializer(0, 0, 0), false);
        this.registerSerializer(new Type(SMALLDATETIME_ID, 0, 0, 0, null), new SqlSmalldatetimeSerializer(0, 0, 0), false);
        this.registerSerializer(new Type(SMALLINT_ID, 0, 0, 0, null), new SqlSmallintSerializer(0, 0, 0), false);
        this.registerSerializer(new Type(SMALLMONEY_ID, 0, 0, 0, null), new SqlSmallmoneySerializer(0, 0, 0), false);
        this.registerSerializer(new Type(TIME_ID, 0, 0, 0, null), new SqlTimeSerializer(0, 0, 0), false);
        this.registerSerializer(new Type(TINYINT_ID, 0, 0, 0, null), new SqlTinyintSerializer(0, 0, 0), false);
        this.registerSerializer(new Type(UNIQUEIDENTIFIER_ID, 0, 0, 0, null), new SqlUniqueidentifierSerializer(0, 0, 0), false);
        this.registerSerializer(new Type(VARBINARY_ID, 0, 0, 0, null), new SqlVarbinarySerializer(0, 0, 0), false);
        this.registerSerializer(new Type(VARCHAR_ID, 0, 0, 0, null), new SqlVarcharSerializer(0, 0, 0), false);
    }

    private boolean hasDefaultSqlSerializer(Type type) {
        return this.serializerByType.containsKey(type);
    }
}

