/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.AeadAes256CbcHmac256EncryptionAlgorithm;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.DataEncryptionKey;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.DataProtector;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.EncryptionSettingsImpl;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.EncryptionType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.ISerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionExceptionResource;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.Serializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.StandardSerializerFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;

public final class CryptographyExtensions {
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final StandardSerializerFactory STANDARD_SERIALIZER_FACTORY = new StandardSerializerFactory();

    private CryptographyExtensions() {
    }

    public static <T> byte[] encrypt(T plaintext, DataEncryptionKey encryptionKey, Class<T> typeParameter) throws MicrosoftDataEncryptionException {
        if (null == encryptionKey) {
            throw new MicrosoftDataEncryptionException(MicrosoftDataEncryptionExceptionResource.getResource("R_NullColumnEncryptionKey"));
        }
        AeadAes256CbcHmac256EncryptionAlgorithm encryptionAlgorithm = AeadAes256CbcHmac256EncryptionAlgorithm.getOrCreate(encryptionKey, EncryptionType.Randomized);
        ISerializer serializer = STANDARD_SERIALIZER_FACTORY.getDefaultSerializer((Class)typeParameter);
        byte[] serializedData = ((Serializer)serializer).serialize(plaintext);
        return ((DataProtector)encryptionAlgorithm).encrypt(serializedData);
    }

    public static <T> T decrypt(byte[] ciphertext, DataEncryptionKey encryptionKey, Class<T> typeParameter) throws MicrosoftDataEncryptionException {
        if (null == encryptionKey) {
            throw new MicrosoftDataEncryptionException(MicrosoftDataEncryptionExceptionResource.getResource("R_NullColumnEncryptionKey"));
        }
        AeadAes256CbcHmac256EncryptionAlgorithm encryptionAlgorithm = AeadAes256CbcHmac256EncryptionAlgorithm.getOrCreate(encryptionKey, EncryptionType.Randomized);
        ISerializer serializer = STANDARD_SERIALIZER_FACTORY.getDefaultSerializer((Class)typeParameter);
        byte[] plaintextData = ((DataProtector)encryptionAlgorithm).decrypt(ciphertext);
        return ((Serializer)serializer).deserialize(plaintextData);
    }

    public static <T> byte[] encrypt(T plaintext, EncryptionSettingsImpl<T> encryptionSettings) throws MicrosoftDataEncryptionException {
        if (null == encryptionSettings) {
            throw new MicrosoftDataEncryptionException(MicrosoftDataEncryptionExceptionResource.getResource("R_NullEncryptionSettings"));
        }
        if (EncryptionType.Plaintext == encryptionSettings.getEncryptionType()) {
            MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_PlaintextEncryptionSettings"));
            Object[] msgArgs = new Object[]{"encryptionSettings"};
            throw new MicrosoftDataEncryptionException(form.format(msgArgs));
        }
        AeadAes256CbcHmac256EncryptionAlgorithm encryptionAlgorithm = AeadAes256CbcHmac256EncryptionAlgorithm.getOrCreate(encryptionSettings.getDataEncryptionKey(), encryptionSettings.getEncryptionType());
        ISerializer serializer = encryptionSettings.getSerializer();
        byte[] serializedData = ((Serializer)serializer).serialize(plaintext);
        return ((DataProtector)encryptionAlgorithm).encrypt(serializedData);
    }

    public static <T> T decrypt(byte[] ciphertext, EncryptionSettingsImpl<T> encryptionSettings) throws MicrosoftDataEncryptionException {
        if (null == encryptionSettings) {
            throw new MicrosoftDataEncryptionException(MicrosoftDataEncryptionExceptionResource.getResource("R_NullEncryptionSettings"));
        }
        if (EncryptionType.Plaintext == encryptionSettings.getEncryptionType()) {
            MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_PlaintextEncryptionSettings"));
            Object[] msgArgs = new Object[]{"encryptionSettings"};
            throw new MicrosoftDataEncryptionException(form.format(msgArgs));
        }
        AeadAes256CbcHmac256EncryptionAlgorithm encryptionAlgorithm = AeadAes256CbcHmac256EncryptionAlgorithm.getOrCreate(encryptionSettings.getDataEncryptionKey(), EncryptionType.Plaintext);
        ISerializer serializer = encryptionSettings.getSerializer();
        byte[] plaintextData = ((DataProtector)encryptionAlgorithm).decrypt(ciphertext);
        return ((Serializer)serializer).deserialize(plaintextData);
    }

    public static <T> Iterable<byte[]> encrypt(Iterable<T> source, DataEncryptionKey encryptionKey, Class<T> typeParameter) throws MicrosoftDataEncryptionException {
        if (null == encryptionKey) {
            throw new MicrosoftDataEncryptionException(MicrosoftDataEncryptionExceptionResource.getResource("R_NullColumnEncryptionKey"));
        }
        AeadAes256CbcHmac256EncryptionAlgorithm encryptionAlgorithm = AeadAes256CbcHmac256EncryptionAlgorithm.getOrCreate(encryptionKey, EncryptionType.Randomized);
        ISerializer serializer = STANDARD_SERIALIZER_FACTORY.getDefaultSerializer((Class)typeParameter);
        ArrayList<byte[]> r = new ArrayList<byte[]>();
        for (T item : source) {
            byte[] serializedData = ((Serializer)serializer).serialize(item);
            r.add(((DataProtector)encryptionAlgorithm).encrypt(serializedData));
        }
        return r;
    }

    public static <T> Iterable<T> decrypt(Iterable<byte[]> source, DataEncryptionKey encryptionKey, Class<T> typeParameter) throws MicrosoftDataEncryptionException {
        if (null == encryptionKey) {
            throw new MicrosoftDataEncryptionException(MicrosoftDataEncryptionExceptionResource.getResource("R_NullColumnEncryptionKey"));
        }
        AeadAes256CbcHmac256EncryptionAlgorithm encryptionAlgorithm = AeadAes256CbcHmac256EncryptionAlgorithm.getOrCreate(encryptionKey, EncryptionType.Randomized);
        ISerializer serializer = STANDARD_SERIALIZER_FACTORY.getDefaultSerializer((Class)typeParameter);
        ArrayList r = new ArrayList();
        for (byte[] item : source) {
            byte[] plaintextData = ((DataProtector)encryptionAlgorithm).decrypt(item);
            r.add(((Serializer)serializer).deserialize(plaintextData));
        }
        return r;
    }

    public static <T> Iterable<byte[]> encrypt(Iterable<T> source, EncryptionSettingsImpl<T> encryptionSettings) throws MicrosoftDataEncryptionException {
        if (null == encryptionSettings) {
            throw new MicrosoftDataEncryptionException(MicrosoftDataEncryptionExceptionResource.getResource("R_NullEncryptionSettings"));
        }
        if (EncryptionType.Plaintext == encryptionSettings.getEncryptionType()) {
            MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_PlaintextEncryptionSettings"));
            Object[] msgArgs = new Object[]{"encryptionSettings"};
            throw new MicrosoftDataEncryptionException(form.format(msgArgs));
        }
        AeadAes256CbcHmac256EncryptionAlgorithm encryptionAlgorithm = AeadAes256CbcHmac256EncryptionAlgorithm.getOrCreate(encryptionSettings.getDataEncryptionKey(), encryptionSettings.getEncryptionType());
        ISerializer serializer = encryptionSettings.getSerializer();
        ArrayList<byte[]> r = new ArrayList<byte[]>();
        for (T item : source) {
            byte[] serializedData = ((Serializer)serializer).serialize(item);
            r.add(((DataProtector)encryptionAlgorithm).encrypt(serializedData));
        }
        return r;
    }

    public static <T> Iterable<T> decrypt(Iterable<byte[]> source, EncryptionSettingsImpl<T> encryptionSettings) throws MicrosoftDataEncryptionException {
        if (null == encryptionSettings) {
            throw new MicrosoftDataEncryptionException(MicrosoftDataEncryptionExceptionResource.getResource("R_NullEncryptionSettings"));
        }
        if (EncryptionType.Plaintext == encryptionSettings.getEncryptionType()) {
            MessageFormat form = new MessageFormat(MicrosoftDataEncryptionExceptionResource.getResource("R_PlaintextEncryptionSettings"));
            Object[] msgArgs = new Object[]{"encryptionSettings"};
            throw new MicrosoftDataEncryptionException(form.format(msgArgs));
        }
        AeadAes256CbcHmac256EncryptionAlgorithm encryptionAlgorithm = AeadAes256CbcHmac256EncryptionAlgorithm.getOrCreate(encryptionSettings.getDataEncryptionKey(), EncryptionType.Plaintext);
        ISerializer serializer = encryptionSettings.getSerializer();
        ArrayList r = new ArrayList();
        for (byte[] item : source) {
            byte[] plaintextData = ((DataProtector)encryptionAlgorithm).decrypt(item);
            r.add(((Serializer)serializer).deserialize(plaintextData));
        }
        return r;
    }

    public static String toBase64String(byte[] source) {
        byte[] encoded = Base64.getEncoder().encode(source);
        return new String(encoded);
    }

    public static byte[] fromBase64String(String source) {
        return Base64.getDecoder().decode(source);
    }

    public static Iterable<String> toBase64String(Iterable<byte[]> source) {
        ArrayList<String> r = new ArrayList<String>();
        for (byte[] item : source) {
            r.add(CryptographyExtensions.toBase64String(item));
        }
        return r;
    }

    public static Iterable<byte[]> fromBase64String(Iterable<String> source) {
        ArrayList<byte[]> r = new ArrayList<byte[]>();
        for (String item : source) {
            r.add(CryptographyExtensions.fromBase64String(item));
        }
        return r;
    }

    public static String toHexString(byte[] source) {
        if (null == source) {
            return null;
        }
        StringBuilder sb = new StringBuilder(source.length * 2);
        for (int i = 0; i < source.length; ++i) {
            int hexVal = source[i] & 0xFF;
            sb.append(hexChars[(hexVal & 0xF0) >> 4]);
            sb.append(hexChars[hexVal & 0xF]);
        }
        return sb.toString();
    }

    static String toHexStringWithDashes(byte[] source) {
        if (null == source) {
            return null;
        }
        StringBuilder sb = new StringBuilder(source.length * 2);
        for (int i = 0; i < source.length; ++i) {
            int hexVal = source[i] & 0xFF;
            sb.append(hexChars[(hexVal & 0xF0) >> 4]);
            sb.append(hexChars[hexVal & 0xF]);
            if (i >= source.length - 1) continue;
            sb.append("-");
        }
        return sb.toString();
    }

    public static byte[] fromHexString(String source) {
        if (null == source) {
            return null;
        }
        int len = source.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(source.charAt(i), 16) << 4) + Character.digit(source.charAt(i + 1), 16));
        }
        return data;
    }

    public static Iterable<String> toHexString(Iterable<byte[]> source) {
        ArrayList<String> r = new ArrayList<String>();
        for (byte[] item : source) {
            r.add(CryptographyExtensions.toHexString(item));
        }
        return r;
    }

    public static Iterable<byte[]> fromHexString(Iterable<String> source) {
        ArrayList<byte[]> r = new ArrayList<byte[]>();
        for (String item : source) {
            r.add(CryptographyExtensions.fromHexString(item));
        }
        return r;
    }
}

