/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.cryptography.KeyEncryptionKeyResolver;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.encryption.CosmosEncryptionAsyncClient;
import com.azure.cosmos.encryption.CosmosEncryptionClient;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;

@ServiceClientBuilder(serviceClients={CosmosEncryptionClient.class, CosmosEncryptionAsyncClient.class})
public class CosmosEncryptionClientBuilder {
    private CosmosAsyncClient cosmosAsyncClient;
    private CosmosClient cosmosClient;
    private KeyEncryptionKeyResolver keyEncryptionKeyResolver;
    private String keyEncryptionKeyResolverName;
    public static final String KEY_RESOLVER_NAME_AZURE_KEY_VAULT = "AZURE_KEY_VAULT";

    public CosmosEncryptionClientBuilder cosmosAsyncClient(CosmosAsyncClient cosmosAsyncClient) {
        this.cosmosAsyncClient = cosmosAsyncClient;
        return this;
    }

    public CosmosEncryptionClientBuilder cosmosClient(CosmosClient cosmosClient) {
        this.cosmosClient = cosmosClient;
        return this;
    }

    public CosmosEncryptionClientBuilder keyEncryptionKeyResolver(KeyEncryptionKeyResolver keyEncryptionKeyResolver) {
        this.keyEncryptionKeyResolver = keyEncryptionKeyResolver;
        return this;
    }

    public CosmosEncryptionClientBuilder keyEncryptionKeyResolverName(String keyEncryptionKeyResolverName) {
        this.keyEncryptionKeyResolverName = keyEncryptionKeyResolverName;
        return this;
    }

    public CosmosEncryptionAsyncClient buildAsyncClient() {
        if (this.cosmosAsyncClient == null) {
            throw new IllegalArgumentException("CosmosAsyncClient has not been provided.");
        }
        if (this.keyEncryptionKeyResolver == null) {
            throw new IllegalArgumentException("KeyEncryptionKeyResolver has not been provided.");
        }
        if (StringUtils.isEmpty((CharSequence)this.keyEncryptionKeyResolverName)) {
            throw new IllegalArgumentException("KeyEncryptionKeyResolverName has not been provided.");
        }
        return new CosmosEncryptionAsyncClient(this.cosmosAsyncClient, this.keyEncryptionKeyResolver, this.keyEncryptionKeyResolverName);
    }

    public CosmosEncryptionClient buildClient() {
        if (this.cosmosClient == null) {
            throw new IllegalArgumentException("CosmosClient has not been provided.");
        }
        if (this.keyEncryptionKeyResolver == null) {
            throw new IllegalArgumentException("KeyEncryptionKeyResolver has not been provided.");
        }
        if (StringUtils.isEmpty((CharSequence)this.keyEncryptionKeyResolverName)) {
            throw new IllegalArgumentException("KeyEncryptionKeyResolverName has not been provided.");
        }
        return new CosmosEncryptionClient(this.cosmosClient, this.keyEncryptionKeyResolver, this.keyEncryptionKeyResolverName);
    }
}

