/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation;

import com.azure.cosmos.implementation.guava27.Strings;

class EncryptionExceptionFactory {
    EncryptionExceptionFactory() {
    }

    static IllegalArgumentException invalidKeySize(String algorithmName, int actualKeylength, int expectedLength) {
        return new InvalidArgumentException(Strings.lenientFormat((String)"Invalid key size for %s; actual: %s, expected: %s", (Object[])new Object[]{algorithmName, actualKeylength, expectedLength}), "dataEncryptionKey");
    }

    static IllegalArgumentException invalidCipherTextSize(int actualSize, int minimumSize) {
        return new InvalidArgumentException(Strings.lenientFormat((String)"Invalid cipher text size; actual: %s, minimum expected: %s.", (Object[])new Object[]{actualSize, minimumSize}), "cipherText");
    }

    static RuntimeException invalidAuthenticationTag() {
        return new InvalidArgumentException("Invalid authentication tag in cipher text.", "cipherText");
    }

    static Exception exceptionKeyNotFoundException(String message, Exception innerException) {
        return new IllegalArgumentException(message, innerException);
    }

    static class InvalidArgumentException
    extends IllegalArgumentException {
        public InvalidArgumentException(String msg, String argName) {
            super(Strings.lenientFormat((String)"argName: %s, details: %s", (Object[])new Object[]{argName, msg}));
        }
    }
}

