/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.JDBCType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SSType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlSerializerUtil;

class SqlTinyintSerializer
extends SqlSerializer {
    public SqlTinyintSerializer(int size, int precision, int scale) {
        this.size = size;
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public byte[] serialize(Object value) throws MicrosoftDataEncryptionException {
        if (value != null) {
            return SqlSerializerUtil.normalizedValue(JDBCType.TINYINT, value, this.precision, this.scale);
        }
        return null;
    }

    @Override
    public Short deserialize(byte[] bytes) throws MicrosoftDataEncryptionException {
        if (null == bytes || bytes.length == 0) {
            return null;
        }
        return (Short)SqlSerializerUtil.denormalizedValue(bytes, JDBCType.TINYINT, SSType.TINYINT, this.precision, this.scale, null);
    }
}

