/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.JDBCType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SSType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlSerializer;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.SqlSerializerUtil;
import java.sql.Timestamp;

class SqlDatetimeSerializer
extends SqlSerializer {
    public SqlDatetimeSerializer(int size, int precision, int scale) {
        this.size = size;
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public byte[] serialize(Object value) throws MicrosoftDataEncryptionException {
        if (value != null) {
            return SqlSerializerUtil.normalizedValue(JDBCType.DATETIME, value, this.precision, this.scale);
        }
        return null;
    }

    @Override
    public Timestamp deserialize(byte[] bytes) throws MicrosoftDataEncryptionException {
        if (null == bytes || bytes.length == 0) {
            return null;
        }
        return (Timestamp)SqlSerializerUtil.denormalizedValue(bytes, JDBCType.DATETIME, SSType.DATETIME, this.precision, this.scale, null);
    }
}

