/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.models;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum CosmosEncryptionAlgorithm {
    AEAD_AES_256_CBC_HMAC_SHA256("AEAD_AES_256_CBC_HMAC_SHA256");

    private final String algorithm;
    private static final Map<String, CosmosEncryptionAlgorithm> ENUM_MAP;

    private CosmosEncryptionAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String toString() {
        return this.algorithm;
    }

    public String getName() {
        return this.algorithm;
    }

    public static CosmosEncryptionAlgorithm get(String name) {
        return ENUM_MAP.get(name);
    }

    static {
        ConcurrentHashMap<String, CosmosEncryptionAlgorithm> map = new ConcurrentHashMap<String, CosmosEncryptionAlgorithm>();
        for (CosmosEncryptionAlgorithm instance : CosmosEncryptionAlgorithm.values()) {
            map.put(instance.getName(), instance);
        }
        ENUM_MAP = Collections.unmodifiableMap(map);
    }
}

