/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.EncryptionKeyStoreProvider;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.KeyEncryptionKeyAlgorithm;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.Quadruple;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.Utils;

public class KeyEncryptionKey {
    private static final KeyEncryptionKeyAlgorithm encryptionAlgorithm = KeyEncryptionKeyAlgorithm.RSA_OAEP;
    private String name;
    private EncryptionKeyStoreProvider keyStoreProvider;
    private String path;
    private boolean isEnclaveSupported;
    private byte[] signature;

    public String getName() {
        return this.name;
    }

    public EncryptionKeyStoreProvider getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public String getPath() {
        return this.path;
    }

    public boolean getIsEnclaveSupported() {
        return this.isEnclaveSupported;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public static KeyEncryptionKey getOrCreate(String name, String path, EncryptionKeyStoreProvider keystore, boolean isEnclaveSupported) throws MicrosoftDataEncryptionException {
        Utils.validateNotNullOrWhitespace(name, "name");
        Utils.validateNotNullOrWhitespace(path, "path");
        Utils.validateNotNull(keystore, "keystore");
        return new KeyEncryptionKey(name, path, keystore, isEnclaveSupported);
    }

    public KeyEncryptionKey(String name, String path, EncryptionKeyStoreProvider keystore, boolean isEnclaveSupported) throws MicrosoftDataEncryptionException {
        Utils.validateNotNullOrWhitespace(name, "name");
        Utils.validateNotNullOrWhitespace(path, "path");
        Utils.validateNotNull(keystore, "keystore");
        this.name = name;
        this.path = path;
        this.keyStoreProvider = keystore;
        this.isEnclaveSupported = isEnclaveSupported;
        this.signature = this.keyStoreProvider.sign(path, isEnclaveSupported);
    }

    public byte[] encryptEncryptionKey(byte[] plaintextEncryptionKey) throws MicrosoftDataEncryptionException {
        return this.keyStoreProvider.wrapKey(this.path, encryptionAlgorithm, plaintextEncryptionKey);
    }

    public byte[] decryptEncryptionKey(byte[] encryptedEncryptionKey) throws MicrosoftDataEncryptionException {
        return this.keyStoreProvider.unwrapKey(this.path, encryptionAlgorithm, encryptedEncryptionKey);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyEncryptionKey)) {
            return false;
        }
        KeyEncryptionKey other = (KeyEncryptionKey)obj;
        return this.name.equals(other.name) && this.keyStoreProvider.equals(other.keyStoreProvider) && this.path.equals(other.path) && this.isEnclaveSupported == other.isEnclaveSupported;
    }

    public int hashCode() {
        return new Quadruple<String, EncryptionKeyStoreProvider, String, Boolean>(this.name, this.keyStoreProvider, this.path, this.isEnclaveSupported).hashCode();
    }
}

