/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.Contexts;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.ProgressReporter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class HttpURLConnectionHttpClient
implements HttpClient {
    public HttpResponse sendSync(HttpRequest request, Context context) {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)request.getUrl().openConnection();
            this.createConnection(connection, request, context);
            HttpResponse httpResponse = this.createHttpResponse(connection, request);
            return httpResponse;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        return this.send(request, Context.NONE);
    }

    public Mono<HttpResponse> send(HttpRequest request, Context context) {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)request.getUrl().openConnection();
            this.createConnection(connection, request, context);
            Mono mono = Mono.just((Object)this.createHttpResponse(connection, request));
            return mono;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void createConnection(HttpURLConnection connection, HttpRequest request, Context context) throws IOException {
        connection.setRequestMethod(request.getHttpMethod().name());
        HttpURLConnectionHttpClient.setHeadersOnRequest(request, connection);
        HttpURLConnectionHttpClient.setBodyOnRequest(request, connection, Contexts.with((Context)context).getHttpRequestProgressReporter());
        connection.setInstanceFollowRedirects(false);
        connection.connect();
    }

    private HttpResponse createHttpResponse(HttpURLConnection connection, HttpRequest request) {
        if (connection == null) {
            return null;
        }
        return new HttpURLResponse(connection, request);
    }

    private static void setBodyOnRequest(HttpRequest request, HttpURLConnection connection, ProgressReporter progressReporter) {
        block8: {
            try {
                BinaryData body = request.getBodyAsBinaryData();
                if (body == null) break block8;
                connection.setDoOutput(true);
                try (BufferedOutputStream stream = new BufferedOutputStream(connection.getOutputStream());){
                    byte[] bodyBytes = body.toBytes();
                    if (progressReporter != null) {
                        progressReporter.reportProgress((long)bodyBytes.length);
                    }
                    stream.write(bodyBytes);
                    stream.flush();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static void setHeadersOnRequest(HttpRequest request, HttpURLConnection connection) {
        HttpHeaders headers = request.getHeaders();
        if (headers != null) {
            for (HttpHeader header : headers) {
                String name = header.getName();
                header.getValuesList().forEach(value -> connection.addRequestProperty(name, (String)value));
            }
        }
    }

    private static class HttpURLResponse
    extends HttpResponse {
        private final HttpURLConnection connection;
        private final byte[] body;

        protected HttpURLResponse(HttpRequest request) {
            super(request);
            this.connection = null;
            this.body = null;
        }

        HttpURLResponse(HttpURLConnection connection, HttpRequest request) {
            super(request);
            this.connection = connection;
            try {
                if (connection.getResponseCode() >= 100 && connection.getResponseCode() < 400) {
                    InputStream inputStream = connection.getInputStream();
                    this.body = HttpURLResponse.readResponseBytes(inputStream);
                } else {
                    InputStream inputStream = connection.getErrorStream();
                    this.body = HttpURLResponse.readResponseBytes(inputStream);
                }
            }
            catch (IOException e) {
                int responseCode = -1;
                String responseMessage = "Unknown error";
                try {
                    responseCode = connection.getResponseCode();
                    responseMessage = connection.getResponseMessage();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new UncheckedIOException(String.format("Connection failed: %s, %s", responseCode, responseMessage), e);
            }
        }

        private static byte[] readResponseBytes(InputStream inputStream) throws IOException {
            int bytesRead;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((bytesRead = bufferedInputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, bytesRead);
            }
            bufferedInputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }

        public int getStatusCode() {
            try {
                return this.connection.getResponseCode();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Deprecated
        public String getHeaderValue(String name) {
            return this.connection.getHeaderField(name);
        }

        public String getHeaderValue(HttpHeaderName headerName) {
            return this.connection.getHeaderField(headerName.getCaseInsensitiveName());
        }

        public HttpHeaders getHeaders() {
            return new HttpHeaders().setAll(this.connection.getHeaderFields());
        }

        public Flux<ByteBuffer> getBody() {
            return Mono.fromSupplier(() -> ByteBuffer.wrap(this.body)).flux();
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.body);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)CoreUtils.bomAwareToString((byte[])this.body, (String)this.getHeaderValue(HttpHeaderName.CONTENT_TYPE)));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.body, charset));
        }

        public BinaryData getBodyAsBinaryData() {
            return BinaryData.fromBytes((byte[])this.body);
        }

        public Mono<InputStream> getBodyAsInputStream() {
            return Mono.fromSupplier(() -> new ByteArrayInputStream(this.body));
        }

        public Mono<Void> writeBodyToAsync(AsynchronousByteChannel channel) {
            return FluxUtil.writeToAsynchronousByteChannel(this.getBody(), (AsynchronousByteChannel)channel);
        }

        public void writeBodyTo(WritableByteChannel channel) throws IOException {
            channel.write(ByteBuffer.wrap(this.body));
        }

        public HttpResponse buffer() {
            return this;
        }

        public void close() {
            this.connection.disconnect();
        }
    }
}

