/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class HttpBinHeaders
implements JsonSerializable<HttpBinHeaders> {
    private static final HttpHeaderName X_PROCESSED_TIME = HttpHeaderName.fromString((String)"X-Processed-Time");
    private static final HttpHeaderName ACCESS_CONTROL_ALLOW_CREDENTIALS = HttpHeaderName.fromString((String)"Access-Control-Allow-Credentials");
    private DateTimeRfc1123 date;
    private String via;
    private String connection;
    private double xProcessedTime;
    private boolean accessControlAllowCredentials;

    public HttpBinHeaders() {
    }

    public HttpBinHeaders(HttpHeaders headers) {
        String accessControlAllowCredentialsHeader;
        String dateHeader = headers.getValue(HttpHeaderName.DATE);
        if (dateHeader != null) {
            this.date = new DateTimeRfc1123(dateHeader);
        }
        this.via = headers.getValue(HttpHeaderName.VIA);
        this.connection = headers.getValue(HttpHeaderName.CONNECTION);
        String xProcessedTimeHeader = headers.getValue(X_PROCESSED_TIME);
        if (xProcessedTimeHeader != null) {
            this.xProcessedTime = Double.parseDouble(xProcessedTimeHeader);
        }
        if ((accessControlAllowCredentialsHeader = headers.getValue(ACCESS_CONTROL_ALLOW_CREDENTIALS)) != null) {
            this.accessControlAllowCredentials = Boolean.parseBoolean(accessControlAllowCredentialsHeader);
        }
    }

    public DateTimeRfc1123 date() {
        return this.date;
    }

    public void date(DateTimeRfc1123 date) {
        this.date = date;
    }

    public String via() {
        return this.via;
    }

    public void via(String via) {
        this.via = via;
    }

    public String connection() {
        return this.connection;
    }

    public void connection(String connection) {
        this.connection = connection;
    }

    public double xProcessedTime() {
        return this.xProcessedTime;
    }

    public boolean accessControlAllowCredentials() {
        return this.accessControlAllowCredentials;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("Date", Objects.toString(this.date, null)).writeStringField("Via", this.via).writeStringField("Connection", this.connection).writeDoubleField("X-Processed-Time", this.xProcessedTime).writeBooleanField("Access-Control-Allow-Credentials", this.accessControlAllowCredentials).writeEndObject();
    }

    public static HttpBinHeaders fromJson(JsonReader jsonReader) throws IOException {
        return (HttpBinHeaders)jsonReader.readObject(reader -> {
            HttpBinHeaders headers = new HttpBinHeaders();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("Date".equals(fieldName)) {
                    headers.date = (DateTimeRfc1123)reader.getNullable(nonNullReader -> new DateTimeRfc1123(nonNullReader.getString()));
                    continue;
                }
                if ("Via".equals(fieldName)) {
                    headers.via = reader.getString();
                    continue;
                }
                if ("Connection".equals(fieldName)) {
                    headers.connection = reader.getString();
                    continue;
                }
                if ("X-Processed-Time".equals(fieldName)) {
                    headers.xProcessedTime = reader.getDouble();
                    continue;
                }
                if ("Access-Control-Allow-Credentials".equals(fieldName)) {
                    headers.accessControlAllowCredentials = reader.getBoolean();
                    continue;
                }
                reader.skipChildren();
            }
            return headers;
        });
    }
}

