/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils.metrics;

import com.azure.core.test.utils.metrics.TestMeasurement;
import com.azure.core.test.utils.metrics.TestTelemetryAttributes;
import com.azure.core.util.Context;
import com.azure.core.util.TelemetryAttributes;
import com.azure.core.util.metrics.LongGauge;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class TestGauge
implements LongGauge {
    private final boolean isEnabled;
    private final ConcurrentLinkedQueue<Subscription> subscriptions = new ConcurrentLinkedQueue();

    TestGauge(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public AutoCloseable registerCallback(Supplier<Long> valueSupplier, TelemetryAttributes attributes) {
        Subscription subscription = new Subscription(valueSupplier, attributes);
        this.subscriptions.add(subscription);
        return subscription;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public List<Subscription> getSubscriptions() {
        return this.subscriptions.stream().collect(Collectors.toList());
    }

    public class Subscription
    implements AutoCloseable {
        private final ConcurrentLinkedQueue<TestMeasurement<Long>> measurements = new ConcurrentLinkedQueue();
        private final Supplier<Long> valueSupplier;
        private final TelemetryAttributes attributes;
        private boolean closed = false;

        Subscription(Supplier<Long> value, TelemetryAttributes attributes) {
            this.valueSupplier = value;
            this.attributes = attributes;
        }

        public void measure() {
            if (!this.closed) {
                this.measurements.add(new TestMeasurement<Long>(this.valueSupplier.get(), (TestTelemetryAttributes)this.attributes, Context.NONE));
            }
        }

        @Override
        public void close() {
            this.closed = true;
            TestGauge.this.subscriptions.remove(this);
        }

        public List<TestMeasurement<Long>> getMeasurements() {
            return this.measurements.stream().collect(Collectors.toList());
        }
    }
}

