/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.models;

import com.azure.core.test.implementation.TestingHelpers;
import com.azure.core.test.models.NetworkCallError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public class NetworkCallRecord
implements JsonSerializable<NetworkCallRecord> {
    private String method;
    private String uri;
    private Map<String, String> headers;
    private Map<String, String> response;
    private NetworkCallError exception;

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getResponse() {
        return this.response;
    }

    public void setResponse(Map<String, String> response) {
        this.response = response;
    }

    public NetworkCallError getException() {
        return this.exception;
    }

    public void setException(NetworkCallError exception) {
        this.exception = exception;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("Method", this.method).writeStringField("Uri", this.uri).writeMapField("Headers", this.headers, JsonWriter::writeString).writeMapField("Response", this.response, JsonWriter::writeString).writeJsonField("Exception", (JsonSerializable)this.exception).writeEndObject();
    }

    public static NetworkCallRecord fromJson(JsonReader jsonReader) throws IOException {
        return TestingHelpers.readObject(jsonReader, NetworkCallRecord::new, (callRecord, fieldName, reader) -> {
            if ("Method".equals(fieldName)) {
                callRecord.method = reader.getString();
            } else if ("Uri".equals(fieldName)) {
                callRecord.uri = reader.getString();
            } else if ("Headers".equals(fieldName)) {
                callRecord.headers = reader.readMap(JsonReader::getString);
            } else if ("Response".equals(fieldName)) {
                callRecord.response = reader.readMap(JsonReader::getString);
            } else if ("Exception".equals(fieldName)) {
                callRecord.exception = NetworkCallError.fromJson(reader);
            } else {
                reader.skipChildren();
            }
        });
    }
}

