/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.test.InterceptorManager;
import com.azure.core.test.TestMode;
import com.azure.core.test.utils.TestResourceNamer;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.util.Locale;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class TestBase {
    private static final String AZURE_TEST_MODE = "AZURE_TEST_MODE";
    private static TestMode testMode;
    private final ClientLogger logger = new ClientLogger(TestBase.class);
    protected InterceptorManager interceptorManager;
    protected TestResourceNamer testResourceNamer;

    @BeforeClass
    public static void setupClass() {
        testMode = TestBase.initializeTestMode();
    }

    @Before
    public void setupTest() {
        String testName = this.getTestName();
        this.logger.info("Test Mode: {}, Name: {}", new Object[]{testMode, testName});
        try {
            this.interceptorManager = new InterceptorManager(testName, testMode);
        }
        catch (IOException e) {
            this.logger.error("Could not create interceptor for {}", new Object[]{testName, e});
            Assert.fail();
        }
        this.testResourceNamer = new TestResourceNamer(testName, testMode, this.interceptorManager.getRecordedData());
        this.beforeTest();
    }

    @After
    public void teardownTest() {
        this.afterTest();
        this.interceptorManager.close();
    }

    public TestMode getTestMode() {
        return testMode;
    }

    protected abstract String getTestName();

    protected void beforeTest() {
    }

    protected void afterTest() {
    }

    private static TestMode initializeTestMode() {
        ClientLogger logger = new ClientLogger(TestBase.class);
        String azureTestMode = Configuration.getGlobalConfiguration().get(AZURE_TEST_MODE);
        if (azureTestMode != null) {
            try {
                return TestMode.valueOf(azureTestMode.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException e) {
                logger.error("Could not parse '{}' into TestEnum. Using 'Playback' mode.", new Object[]{azureTestMode});
                return TestMode.PLAYBACK;
            }
        }
        logger.info("Environment variable '{}' has not been set yet. Using 'Playback' mode.", new Object[]{AZURE_TEST_MODE});
        return TestMode.PLAYBACK;
    }
}

