/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.jackson.models;

import com.azure.core.serializer.json.jackson.models.JacksonJsonElementUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.json.models.JsonElement;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Objects;

public final class JacksonJsonObject
extends JsonElement {
    private final ObjectNode object;

    public JacksonJsonObject() {
        this(JsonNodeFactory.instance.objectNode());
    }

    public JacksonJsonObject(ObjectNode object) {
        this.object = Objects.requireNonNull(object, "'object' cannot be null.");
    }

    public JsonNode getProperty(String key) {
        return this.object.get(key);
    }

    public JacksonJsonObject setProperty(String key, JsonNode node) {
        this.object.set(key, JacksonJsonObject.nullCheck(node));
        return this;
    }

    public JsonNode removeProperty(String key) {
        return this.object.remove(key);
    }

    private static JsonNode nullCheck(JsonNode node) {
        return Objects.requireNonNull(node, "The JsonNode cannot be null. If null must be represented in JSON, use NullNode.");
    }

    public int size() {
        return this.object.size();
    }

    public boolean isObject() {
        return true;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return JacksonJsonElementUtils.writeObjectNode(jsonWriter, this.object);
    }

    public static JacksonJsonObject fromJson(JsonReader jsonReader) throws IOException {
        JsonToken token = jsonReader.currentToken();
        if (token == null) {
            token = jsonReader.nextToken();
        }
        if (token != JsonToken.START_OBJECT) {
            throw new IllegalStateException("JsonReader is pointing to an invalid token for deserialization. Token was: " + token + ".");
        }
        return new JacksonJsonObject(JacksonJsonElementUtils.readObjectNode(jsonReader));
    }
}

