/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.jackson.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

final class JacksonJsonElementUtils {
    public static JsonNode readJsonNode(JsonReader jsonReader) throws IOException {
        Objects.requireNonNull(jsonReader, "'jsonReader' cannot be null.");
        JsonToken currentToken = jsonReader.currentToken();
        if (currentToken == null) {
            currentToken = jsonReader.nextToken();
        }
        switch (currentToken) {
            case START_OBJECT: {
                return JacksonJsonElementUtils.readObjectNode(jsonReader);
            }
            case START_ARRAY: {
                return JacksonJsonElementUtils.readArrayNode(jsonReader);
            }
            case BOOLEAN: {
                return jsonReader.getBoolean() ? BooleanNode.TRUE : BooleanNode.FALSE;
            }
            case NULL: {
                return NullNode.getInstance();
            }
            case NUMBER: {
                return JacksonJsonElementUtils.parseNumeric(jsonReader.getString());
            }
            case STRING: {
                return new TextNode(jsonReader.getString());
            }
        }
        throw new IllegalArgumentException("Unsupported JsonToken type: " + currentToken);
    }

    private static NumericNode parseNumeric(String value) {
        int length = value.length();
        boolean floatingPoint = false;
        boolean infinity = value.contains("Infinity");
        if (infinity) {
            return new DoubleNode(Double.parseDouble(value));
        }
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c != '.' && c != 'e' && c != 'E') continue;
            floatingPoint = true;
            break;
        }
        return floatingPoint ? JacksonJsonElementUtils.handleFloatingPoint(value) : JacksonJsonElementUtils.handleInteger(value);
    }

    private static NumericNode handleFloatingPoint(String value) {
        float f = Float.parseFloat(value);
        if (!Float.isInfinite(f)) {
            return new FloatNode(f);
        }
        double d = Double.parseDouble(value);
        if (!Double.isInfinite(d)) {
            return new DoubleNode(d);
        }
        return new DecimalNode(new BigDecimal(value));
    }

    private static NumericNode handleInteger(String value) {
        try {
            return new IntNode(Integer.parseInt(value));
        }
        catch (NumberFormatException failedInteger) {
            try {
                return new LongNode(Long.parseLong(value));
            }
            catch (NumberFormatException failedLong) {
                failedLong.addSuppressed(failedInteger);
                try {
                    return new BigIntegerNode(new BigInteger(value));
                }
                catch (NumberFormatException failedBigDecimal) {
                    failedBigDecimal.addSuppressed(failedLong);
                    throw failedBigDecimal;
                }
            }
        }
    }

    static ArrayNode readArrayNode(JsonReader jsonReader) throws IOException {
        ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
        while (jsonReader.nextToken() != JsonToken.END_ARRAY) {
            arrayNode.add(JacksonJsonElementUtils.readJsonNode(jsonReader));
        }
        return arrayNode;
    }

    static ObjectNode readObjectNode(JsonReader jsonReader) throws IOException {
        ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
        while (jsonReader.nextToken() != JsonToken.END_ARRAY) {
            String fieldName = jsonReader.getFieldName();
            jsonReader.nextToken();
            objectNode.set(fieldName, JacksonJsonElementUtils.readJsonNode(jsonReader));
        }
        return objectNode;
    }

    public static JsonWriter writeJsonNode(JsonWriter jsonWriter, JsonNode jsonNode) throws IOException {
        if (jsonNode == null) {
            return jsonWriter.writeNull();
        }
        if (jsonNode instanceof ArrayNode) {
            return JacksonJsonElementUtils.writeArrayNode(jsonWriter, (ArrayNode)jsonNode);
        }
        if (jsonNode instanceof BinaryNode) {
            return jsonWriter.writeBinary(((BinaryNode)jsonNode).binaryValue());
        }
        if (jsonNode.isBoolean()) {
            return jsonWriter.writeBoolean(jsonNode.booleanValue());
        }
        if (jsonNode.isNull()) {
            return jsonWriter.writeNull();
        }
        if (jsonNode.isNumber()) {
            return jsonWriter.writeNumber(jsonNode.numberValue());
        }
        if (jsonNode instanceof ObjectNode) {
            return JacksonJsonElementUtils.writeObjectNode(jsonWriter, (ObjectNode)jsonNode);
        }
        if (jsonNode.isTextual()) {
            return jsonWriter.writeString(jsonNode.textValue());
        }
        throw new IllegalArgumentException("Unsupported JsonNode type: " + jsonNode.getNodeType());
    }

    static JsonWriter writeArrayNode(JsonWriter jsonWriter, ArrayNode arrayNode) throws IOException {
        if (arrayNode == null) {
            return jsonWriter.writeNull();
        }
        jsonWriter.writeStartArray();
        for (JsonNode jsonNode : arrayNode) {
            JacksonJsonElementUtils.writeJsonNode(jsonWriter, jsonNode);
        }
        jsonWriter.writeEndArray();
        return jsonWriter;
    }

    static JsonWriter writeObjectNode(JsonWriter jsonWriter, ObjectNode objectNode) throws IOException {
        if (objectNode == null) {
            return jsonWriter.writeNull();
        }
        jsonWriter.writeStartObject();
        Iterator it = objectNode.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            jsonWriter.writeFieldName((String)entry.getKey());
            JacksonJsonElementUtils.writeJsonNode(jsonWriter, (JsonNode)entry.getValue());
        }
        jsonWriter.writeEndObject();
        return jsonWriter;
    }

    private JacksonJsonElementUtils() {
    }
}

