/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.gson.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;

final class GsonJsonElementUtils {
    public static JsonElement readJsonElement(JsonReader jsonReader) throws IOException {
        Objects.requireNonNull(jsonReader, "'jsonReader' cannot be null.");
        JsonToken currentToken = jsonReader.currentToken();
        if (currentToken == null) {
            currentToken = jsonReader.nextToken();
        }
        switch (currentToken) {
            case START_OBJECT: {
                return GsonJsonElementUtils.readJsonObject(jsonReader);
            }
            case START_ARRAY: {
                return GsonJsonElementUtils.readJsonArray(jsonReader);
            }
            case BOOLEAN: {
                return new JsonPrimitive(Boolean.valueOf(jsonReader.getBoolean()));
            }
            case NULL: {
                return JsonNull.INSTANCE;
            }
            case NUMBER: {
                return GsonJsonElementUtils.parseNumeric(jsonReader.getString());
            }
            case STRING: {
                return new JsonPrimitive(jsonReader.getString());
            }
        }
        throw new IllegalArgumentException("Unsupported JsonToken type: " + currentToken);
    }

    private static JsonPrimitive parseNumeric(String value) {
        int length = value.length();
        boolean floatingPoint = false;
        boolean infinity = value.contains("Infinity");
        if (infinity) {
            return new JsonPrimitive((Number)Double.parseDouble(value));
        }
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c != '.' && c != 'e' && c != 'E') continue;
            floatingPoint = true;
            break;
        }
        return floatingPoint ? GsonJsonElementUtils.handleFloatingPoint(value) : GsonJsonElementUtils.handleInteger(value);
    }

    private static JsonPrimitive handleFloatingPoint(String value) {
        float f = Float.parseFloat(value);
        if (!Float.isInfinite(f)) {
            return new JsonPrimitive((Number)Float.valueOf(f));
        }
        double d = Double.parseDouble(value);
        if (!Double.isInfinite(d)) {
            return new JsonPrimitive((Number)d);
        }
        return new JsonPrimitive((Number)new BigDecimal(value));
    }

    private static JsonPrimitive handleInteger(String value) {
        try {
            return new JsonPrimitive((Number)Integer.parseInt(value));
        }
        catch (NumberFormatException failedInteger) {
            try {
                return new JsonPrimitive((Number)Long.parseLong(value));
            }
            catch (NumberFormatException failedLong) {
                failedLong.addSuppressed(failedInteger);
                try {
                    return new JsonPrimitive((Number)new BigInteger(value));
                }
                catch (NumberFormatException failedBigDecimal) {
                    failedBigDecimal.addSuppressed(failedLong);
                    throw failedBigDecimal;
                }
            }
        }
    }

    static JsonArray readJsonArray(JsonReader jsonReader) throws IOException {
        JsonArray jsonArray = new JsonArray();
        while (jsonReader.nextToken() != JsonToken.END_ARRAY) {
            jsonArray.add(GsonJsonElementUtils.readJsonElement(jsonReader));
        }
        return jsonArray;
    }

    static JsonObject readJsonObject(JsonReader jsonReader) throws IOException {
        JsonObject jsonObject = new JsonObject();
        while (jsonReader.nextToken() != JsonToken.END_ARRAY) {
            String fieldName = jsonReader.getFieldName();
            jsonReader.nextToken();
            jsonObject.add(fieldName, GsonJsonElementUtils.readJsonElement(jsonReader));
        }
        return jsonObject;
    }

    public static JsonWriter writeJsonElement(JsonWriter jsonWriter, JsonElement jsonElement) throws IOException {
        if (jsonElement == null) {
            return jsonWriter.writeNull();
        }
        if (jsonElement.isJsonArray()) {
            return GsonJsonElementUtils.writeJsonArray(jsonWriter, jsonElement.getAsJsonArray());
        }
        if (jsonElement.isJsonNull()) {
            return jsonWriter.writeNull();
        }
        if (jsonElement.isJsonObject()) {
            return GsonJsonElementUtils.writeJsonObject(jsonWriter, jsonElement.getAsJsonObject());
        }
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
            if (jsonPrimitive.isBoolean()) {
                return jsonWriter.writeBoolean(jsonPrimitive.getAsBoolean());
            }
            if (jsonPrimitive.isNumber()) {
                return jsonWriter.writeNumber(jsonPrimitive.getAsNumber());
            }
            if (jsonPrimitive.isString()) {
                return jsonWriter.writeString(jsonPrimitive.getAsString());
            }
        }
        throw new IllegalArgumentException("Unsupported JsonNode type: " + jsonElement.getClass());
    }

    static JsonWriter writeJsonArray(JsonWriter jsonWriter, JsonArray jsonArray) throws IOException {
        if (jsonArray == null) {
            return jsonWriter.writeNull();
        }
        jsonWriter.writeStartArray();
        for (JsonElement jsonNode : jsonArray) {
            GsonJsonElementUtils.writeJsonElement(jsonWriter, jsonNode);
        }
        jsonWriter.writeEndArray();
        return jsonWriter;
    }

    static JsonWriter writeJsonObject(JsonWriter jsonWriter, JsonObject jsonObject) throws IOException {
        if (jsonObject == null) {
            return jsonWriter.writeNull();
        }
        jsonWriter.writeStartObject();
        for (Map.Entry entry : jsonObject.asMap().entrySet()) {
            jsonWriter.writeFieldName((String)entry.getKey());
            GsonJsonElementUtils.writeJsonElement(jsonWriter, (JsonElement)entry.getValue());
        }
        jsonWriter.writeEndObject();
        return jsonWriter;
    }

    private GsonJsonElementUtils() {
    }
}

