/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.gson.models;

import com.azure.core.serializer.json.gson.models.GsonJsonElementUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.json.models.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Objects;

public final class GsonJsonObject
extends JsonElement {
    private final JsonObject object;

    public GsonJsonObject() {
        this(new JsonObject());
    }

    public GsonJsonObject(JsonObject object) {
        this.object = Objects.requireNonNull(object, "'object' cannot be null.");
    }

    public com.google.gson.JsonElement getProperty(String key) {
        return this.object.get(key);
    }

    public GsonJsonObject setProperty(String key, com.google.gson.JsonElement element) {
        this.object.add(key, GsonJsonObject.nullCheck(element));
        return this;
    }

    public com.google.gson.JsonElement removeProperty(String key) {
        return this.object.remove(key);
    }

    private static com.google.gson.JsonElement nullCheck(com.google.gson.JsonElement element) {
        return Objects.requireNonNull(element, "The JsonElement cannot be null. If null must be represented in JSON, use JsonNull.");
    }

    public int size() {
        return this.object.size();
    }

    public boolean isObject() {
        return true;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return GsonJsonElementUtils.writeJsonObject(jsonWriter, this.object);
    }

    public static GsonJsonObject fromJson(JsonReader jsonReader) throws IOException {
        JsonToken token = jsonReader.currentToken();
        if (token == null) {
            token = jsonReader.nextToken();
        }
        if (token != JsonToken.START_OBJECT) {
            throw new IllegalStateException("JsonReader is pointing to an invalid token for deserialization. Token was: " + token + ".");
        }
        return new GsonJsonObject(GsonJsonElementUtils.readJsonObject(jsonReader));
    }
}

