/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.gson.implementation;

import com.azure.core.serializer.json.gson.implementation.AzureJsonUtils;
import com.azure.core.serializer.json.gson.implementation.CustomGsonReader;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonOptions;
import com.azure.json.JsonToken;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Base64;
import java.util.Objects;

public final class GsonJsonReader
extends com.azure.json.JsonReader {
    private static final ClientLogger LOGGER = new ClientLogger(GsonJsonReader.class);
    private final JsonReader reader;
    private final byte[] jsonBytes;
    private final String jsonString;
    private final boolean resetSupported;
    private final JsonOptions jsonOptions;
    private final boolean typeAdapterContext;
    private JsonToken currentToken;
    private boolean consumed = false;
    private Object value = null;
    private boolean complete = false;
    private int objectDepth = 0;

    public GsonJsonReader(Reader reader, byte[] jsonBytes, String jsonString, boolean resetSupported, JsonOptions options) {
        this(GsonJsonReader.createGsonReader(Objects.requireNonNull(reader, "Cannot create a GSON-based instance of com.azure.json.JsonReader with a null GSON JsonReader."), options), jsonBytes, jsonString, resetSupported, options, false);
    }

    private static JsonReader createGsonReader(Reader reader, JsonOptions options) {
        CustomGsonReader gsonReader = new CustomGsonReader(reader, options);
        gsonReader.setLenient(options == null || options.isNonNumericNumbersSupported() || options.isJsoncSupported());
        return gsonReader;
    }

    public GsonJsonReader(JsonReader reader, JsonOptions options, boolean typeAdapterContext) {
        this(Objects.requireNonNull(reader, "Cannot create a GSON-based instance of com.azure.json.JsonReader with a null GSON JsonReader."), null, null, false, options, typeAdapterContext);
    }

    private GsonJsonReader(JsonReader reader, byte[] jsonBytes, String jsonString, boolean resetSupported, JsonOptions options, boolean typeAdapterContext) {
        this.reader = reader;
        this.jsonBytes = jsonBytes;
        this.jsonString = jsonString;
        this.resetSupported = resetSupported;
        this.jsonOptions = options;
        this.typeAdapterContext = typeAdapterContext;
    }

    public JsonToken currentToken() {
        return this.currentToken;
    }

    public JsonToken nextToken() throws IOException {
        if (this.complete) {
            return this.currentToken;
        }
        if (this.currentToken == JsonToken.START_OBJECT) {
            this.reader.beginObject();
            ++this.objectDepth;
        } else if (this.currentToken == JsonToken.END_OBJECT) {
            this.reader.endObject();
            --this.objectDepth;
        } else if (this.currentToken == JsonToken.START_ARRAY) {
            this.reader.beginArray();
        } else if (this.currentToken == JsonToken.END_ARRAY) {
            this.reader.endArray();
        } else if (this.currentToken == JsonToken.NULL) {
            this.reader.nextNull();
        }
        if (!this.consumed && this.currentToken != null) {
            switch (this.currentToken) {
                case FIELD_NAME: {
                    this.reader.nextName();
                    break;
                }
                case BOOLEAN: {
                    this.reader.nextBoolean();
                    break;
                }
                case NUMBER: {
                    this.reader.nextDouble();
                    break;
                }
                case STRING: {
                    this.reader.nextString();
                    break;
                }
            }
        }
        this.currentToken = GsonJsonReader.mapToken(this.reader.peek());
        if (this.currentToken == JsonToken.END_DOCUMENT) {
            this.complete = true;
        }
        if (this.typeAdapterContext && this.objectDepth == 1 && this.currentToken == JsonToken.END_OBJECT) {
            this.reader.endObject();
        }
        this.consumed = false;
        this.value = null;
        return this.currentToken;
    }

    public byte[] getBinary() throws IOException {
        if (this.consumed) {
            return (byte[])this.value;
        }
        this.consumed = true;
        if (this.currentToken == JsonToken.NULL) {
            this.reader.nextNull();
            this.value = null;
        } else {
            this.value = Base64.getDecoder().decode(this.reader.nextString());
        }
        return (byte[])this.value;
    }

    public boolean getBoolean() throws IOException {
        if (this.consumed) {
            return (Boolean)this.value;
        }
        this.consumed = true;
        this.value = this.reader.nextBoolean();
        return (Boolean)this.value;
    }

    public double getDouble() throws IOException {
        if (this.consumed) {
            return (Double)this.value;
        }
        this.consumed = true;
        this.value = this.reader.nextDouble();
        return (Double)this.value;
    }

    public float getFloat() throws IOException {
        return (float)this.getDouble();
    }

    public int getInt() throws IOException {
        if (this.consumed) {
            return (Integer)this.value;
        }
        this.consumed = true;
        this.value = this.reader.nextInt();
        return (Integer)this.value;
    }

    public long getLong() throws IOException {
        if (this.consumed) {
            return (Long)this.value;
        }
        this.consumed = true;
        this.value = this.reader.nextLong();
        return (Long)this.value;
    }

    public String getString() throws IOException {
        if (this.consumed) {
            return (String)this.value;
        }
        this.consumed = true;
        if (this.currentToken == JsonToken.NULL) {
            this.reader.nextNull();
            this.value = null;
        } else {
            this.value = this.reader.nextString();
        }
        return (String)this.value;
    }

    public String getFieldName() throws IOException {
        if (this.consumed) {
            return (String)this.value;
        }
        this.consumed = true;
        this.value = this.reader.nextName();
        return (String)this.value;
    }

    public void skipChildren() throws IOException {
        this.consumed = true;
        this.reader.skipValue();
    }

    public com.azure.json.JsonReader bufferObject() throws IOException {
        if (this.currentToken == JsonToken.START_OBJECT || this.currentToken == JsonToken.FIELD_NAME) {
            this.consumed = true;
            String json = this.readRemainingFieldsAsJsonObject();
            return AzureJsonUtils.createReader(json, this.jsonOptions);
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot buffer a JSON object from a non-object, non-field name starting location. Starting location: " + this.currentToken()));
    }

    public boolean isResetSupported() {
        return this.resetSupported;
    }

    public com.azure.json.JsonReader reset() throws IOException {
        if (!this.resetSupported) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'reset' isn't supported by this JsonReader."));
        }
        return this.jsonBytes != null ? AzureJsonUtils.createReader(this.jsonBytes, this.jsonOptions) : AzureJsonUtils.createReader(this.jsonString, this.jsonOptions);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    private static JsonToken mapToken(com.google.gson.stream.JsonToken token) {
        if (token == null) {
            return null;
        }
        switch (token) {
            case BEGIN_OBJECT: {
                return JsonToken.START_OBJECT;
            }
            case END_OBJECT: {
                return JsonToken.END_OBJECT;
            }
            case BEGIN_ARRAY: {
                return JsonToken.START_ARRAY;
            }
            case END_ARRAY: {
                return JsonToken.END_ARRAY;
            }
            case NAME: {
                return JsonToken.FIELD_NAME;
            }
            case STRING: {
                return JsonToken.STRING;
            }
            case NUMBER: {
                return JsonToken.NUMBER;
            }
            case BOOLEAN: {
                return JsonToken.BOOLEAN;
            }
            case NULL: {
                return JsonToken.NULL;
            }
            case END_DOCUMENT: {
                return JsonToken.END_DOCUMENT;
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Unsupported token type: '" + token + "'."));
    }
}

