/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.vertx.implementation;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.CoreUtils;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpClientResponse;
import java.nio.charset.Charset;
import java.util.Map;
import reactor.core.publisher.Mono;

abstract class VertxHttpResponseBase
extends HttpResponse {
    private final HttpClientResponse vertxHttpResponse;
    private final HttpHeaders headers;

    VertxHttpResponseBase(HttpRequest azureHttpRequest, HttpClientResponse vertxHttpResponse) {
        super(azureHttpRequest);
        this.vertxHttpResponse = vertxHttpResponse;
        this.headers = this.fromVertxHttpHeaders(vertxHttpResponse.headers());
    }

    private HttpHeaders fromVertxHttpHeaders(MultiMap headers) {
        HttpHeaders azureHeaders = new HttpHeaders();
        for (Map.Entry header : headers) {
            azureHeaders.add((String)header.getKey(), (String)header.getValue());
        }
        return azureHeaders;
    }

    HttpClientResponse getVertxHttpResponse() {
        return this.vertxHttpResponse;
    }

    public int getStatusCode() {
        return this.vertxHttpResponse.statusCode();
    }

    @Deprecated
    public String getHeaderValue(String name) {
        return this.headers.getValue(name);
    }

    public String getHeaderValue(HttpHeaderName headerName) {
        return this.headers.getValue(headerName);
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public final Mono<String> getBodyAsString() {
        return this.getBodyAsByteArray().map(bytes -> CoreUtils.bomAwareToString((byte[])bytes, (String)this.getHeaderValue(HttpHeaderName.CONTENT_TYPE)));
    }

    public final Mono<String> getBodyAsString(Charset charset) {
        return this.getBodyAsByteArray().map(bytes -> CoreUtils.bomAwareToString((byte[])bytes, (String)charset.toString()));
    }
}

