/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.vertx;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpClientProvider;
import com.azure.core.http.vertx.VertxHttpClientBuilder;
import com.azure.core.util.Configuration;
import com.azure.core.util.HttpClientOptions;

public class VertxHttpClientProvider
implements HttpClientProvider {
    private static final boolean AZURE_ENABLE_HTTP_CLIENT_SHARING = (Boolean)Configuration.getGlobalConfiguration().get("AZURE_ENABLE_HTTP_CLIENT_SHARING", (Object)Boolean.FALSE);
    private final boolean enableHttpClientSharing;

    public VertxHttpClientProvider() {
        this.enableHttpClientSharing = AZURE_ENABLE_HTTP_CLIENT_SHARING;
    }

    VertxHttpClientProvider(Configuration configuration) {
        this.enableHttpClientSharing = (Boolean)configuration.get("AZURE_ENABLE_HTTP_CLIENT_SHARING", (Object)Boolean.FALSE);
    }

    public HttpClient createInstance() {
        if (this.enableHttpClientSharing) {
            return GlobalVertxHttpClient.HTTP_CLIENT.getHttpClient();
        }
        return new VertxHttpClientBuilder().build();
    }

    public HttpClient createInstance(HttpClientOptions clientOptions) {
        if (clientOptions == null) {
            return this.createInstance();
        }
        return new VertxHttpClientBuilder().proxy(clientOptions.getProxyOptions()).configuration(clientOptions.getConfiguration()).connectTimeout(clientOptions.getConnectTimeout()).writeTimeout(clientOptions.getWriteTimeout()).responseTimeout(clientOptions.getResponseTimeout()).readTimeout(clientOptions.getReadTimeout()).build();
    }

    private static enum GlobalVertxHttpClient {
        HTTP_CLIENT(new VertxHttpClientBuilder().build());

        private final HttpClient httpClient;

        private GlobalVertxHttpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
        }

        private HttpClient getHttpClient() {
            return this.httpClient;
        }
    }
}

