/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp.implementation;

import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class BinaryDataRequestBody
extends RequestBody {
    private static final ClientLogger LOGGER = new ClientLogger(BinaryDataRequestBody.class);
    private final MediaType contentType;
    private final BinaryData body;
    private final long effectiveContentLength;
    private volatile int bodySent = 0;
    private static final AtomicIntegerFieldUpdater<BinaryDataRequestBody> BODY_SENT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(BinaryDataRequestBody.class, "bodySent");

    public BinaryDataRequestBody(BinaryData body, MediaType contentType, long effectiveContentLength) {
        this.body = body;
        this.contentType = contentType;
        this.effectiveContentLength = effectiveContentLength;
    }

    public long contentLength() throws IOException {
        return this.effectiveContentLength;
    }

    public boolean isOneShot() {
        return !this.body.isReplayable();
    }

    public MediaType contentType() {
        return this.contentType;
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        if (!this.body.isReplayable() && !BODY_SENT_UPDATER.compareAndSet(this, 0, 1)) {
            throw (IOException)LOGGER.logThrowableAsError((Throwable)new IOException("Re-attempt to send body is not supported."));
        }
        this.body.writeTo((WritableByteChannel)bufferedSink);
    }
}

