/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.jdk.httpclient.implementation;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.SharedExecutorService;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpTimeoutException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;

public final class InputStreamWithReadTimeout
extends InputStream {
    private final Duration readTimeout;
    private final boolean hasTimeout;
    private final InputStream delegate;

    public InputStreamWithReadTimeout(InputStream delegate, Duration readTimeout) {
        this.delegate = delegate;
        this.readTimeout = readTimeout;
        this.hasTimeout = readTimeout != null && !readTimeout.isNegative() && !readTimeout.isZero();
    }

    @Override
    public int read() throws IOException {
        if (this.hasTimeout) {
            Future readOp = SharedExecutorService.getInstance().submit(() -> this.delegate.read());
            return (Integer)InputStreamWithReadTimeout.getResultWithTimeout(readOp, this.readTimeout);
        }
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        Objects.requireNonNull(b, "'b' cannot be null.");
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Objects.checkFromIndexSize(off, len, b.length);
        if (this.hasTimeout) {
            int toRead = Math.min(len, 8192);
            Future readOp = SharedExecutorService.getInstance().submit(() -> this.delegate.read(b, off, toRead));
            return (Integer)InputStreamWithReadTimeout.getResultWithTimeout(readOp, this.readTimeout);
        }
        return this.delegate.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        int bytesRead;
        long remaining;
        if (n <= 0L) {
            return 0L;
        }
        int size = (int)Math.min(8192L, remaining);
        byte[] skipBuffer = new byte[size];
        for (remaining = n; remaining > 0L && (bytesRead = this.read(skipBuffer, 0, (int)Math.min((long)size, remaining))) >= 0; remaining -= (long)bytesRead) {
        }
        return n - remaining;
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    private static <T> T getResultWithTimeout(Future<T> future, Duration timeout) throws IOException {
        try {
            return (T)CoreUtils.getResultWithTimeout(future, (Duration)timeout);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
        catch (TimeoutException e) {
            throw new HttpTimeoutException("Timeout reading response body.");
        }
    }
}

