/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.jdk.httpclient.implementation;

import com.azure.core.http.jdk.httpclient.implementation.JdkHttpUtils;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledFuture;

public final class ByteArrayTimeoutResponseSubscriber
implements HttpResponse.BodySubscriber<byte[]> {
    private final CompletableFuture<byte[]> future = new CompletableFuture();
    private final List<ByteBuffer> received = new ArrayList<ByteBuffer>();
    private final long readTimeout;
    private ScheduledFuture<?> currentTimeout;
    private volatile Flow.Subscription subscription;

    public ByteArrayTimeoutResponseSubscriber(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        if (this.subscription != null) {
            subscription.cancel();
            return;
        }
        this.subscription = subscription;
        this.currentTimeout = this.createTimeout();
        subscription.request(1L);
    }

    @Override
    public void onNext(List<ByteBuffer> item) {
        this.currentTimeout.cancel(false);
        this.received.addAll(item);
        this.currentTimeout = this.createTimeout();
        this.subscription.request(1L);
    }

    @Override
    public void onError(Throwable throwable) {
        this.currentTimeout.cancel(false);
        this.received.clear();
        this.future.completeExceptionally(throwable);
    }

    @Override
    public void onComplete() {
        this.currentTimeout.cancel(false);
        int size = JdkHttpUtils.getSizeOfBuffers(this.received);
        byte[] result = new byte[size];
        int offset = 0;
        for (ByteBuffer buffer : this.received) {
            int length = buffer.remaining();
            buffer.get(result, offset, length);
            offset += length;
        }
        this.future.complete(result);
    }

    private ScheduledFuture<?> createTimeout() {
        return JdkHttpUtils.scheduleTimeoutTask(() -> {
            this.future.completeExceptionally(new HttpTimeoutException("Timeout reading response body."));
            this.subscription.cancel();
        }, this.readTimeout);
    }

    @Override
    public CompletionStage<byte[]> getBody() {
        return this.future;
    }
}

