/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.jdk.httpclient.implementation;

import com.azure.core.http.HttpHeader;
import com.azure.core.util.logging.ClientLogger;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

final class HeaderFilteringMap
extends AbstractMap<String, List<String>> {
    private final Map<String, HttpHeader> rawHeaders;
    private final Set<String> restrictedHeaders;
    private final ClientLogger logger;

    HeaderFilteringMap(Map<String, HttpHeader> rawHeaders, Set<String> restrictedHeaders, ClientLogger logger) {
        this.rawHeaders = rawHeaders;
        this.restrictedHeaders = restrictedHeaders;
        this.logger = logger;
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("The only operation permitted by this Map is forEach."));
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super List<String>> action) {
        this.rawHeaders.forEach((? super K headerName, ? super V header) -> {
            if (this.restrictedHeaders.contains(headerName)) {
                this.logger.atWarning().addKeyValue("headerName", headerName).log("The header is restricted by 'java.net.http.HttpClient' and will be ignored. To allow this header to be set on the request, configure 'jdk.httpclient.allowRestrictedHeaders' with the header added in the comma-separated list.");
            } else {
                action.accept(header.getName(), header.getValuesList());
            }
        });
    }
}

