/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation.models;

import com.azure.containers.containerregistry.implementation.models.Manifest;
import com.azure.containers.containerregistry.implementation.models.ManifestListAttributes;
import com.azure.containers.containerregistry.models.OciAnnotations;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class OCIIndex
extends Manifest {
    private List<ManifestListAttributes> manifests;
    private OciAnnotations annotations;

    public List<ManifestListAttributes> getManifests() {
        return this.manifests;
    }

    public OCIIndex setManifests(List<ManifestListAttributes> manifests) {
        this.manifests = manifests;
        return this;
    }

    public OciAnnotations getAnnotations() {
        return this.annotations;
    }

    public OCIIndex setAnnotations(OciAnnotations annotations) {
        this.annotations = annotations;
        return this;
    }

    @Override
    public OCIIndex setSchemaVersion(Integer schemaVersion) {
        super.setSchemaVersion(schemaVersion);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("schemaVersion", (Number)this.getSchemaVersion());
        jsonWriter.writeArrayField("manifests", this.manifests, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("annotations", (JsonSerializable)this.annotations);
        return jsonWriter.writeEndObject();
    }

    public static OCIIndex fromJson(JsonReader jsonReader) throws IOException {
        return (OCIIndex)jsonReader.readObject(reader -> {
            OCIIndex deserializedOCIIndex = new OCIIndex();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schemaVersion".equals(fieldName)) {
                    deserializedOCIIndex.setSchemaVersion((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("manifests".equals(fieldName)) {
                    List manifests;
                    deserializedOCIIndex.manifests = manifests = reader.readArray(reader1 -> ManifestListAttributes.fromJson(reader1));
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    deserializedOCIIndex.annotations = OciAnnotations.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOCIIndex;
        });
    }
}

