/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry;

import com.azure.containers.containerregistry.ContainerRegistryContentClientBuilder;
import com.azure.containers.containerregistry.implementation.AzureContainerRegistryImpl;
import com.azure.containers.containerregistry.implementation.ConstructorAccessors;
import com.azure.containers.containerregistry.implementation.ContainerRegistriesImpl;
import com.azure.containers.containerregistry.implementation.ContainerRegistryBlobsImpl;
import com.azure.containers.containerregistry.implementation.UtilsImpl;
import com.azure.containers.containerregistry.implementation.models.AcrErrorsException;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistriesCreateManifestHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsCompleteUploadHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsDeleteBlobHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsGetChunkHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsStartUploadHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistryBlobsUploadChunkHeaders;
import com.azure.containers.containerregistry.models.GetManifestResult;
import com.azure.containers.containerregistry.models.ManifestMediaType;
import com.azure.containers.containerregistry.models.OciImageManifest;
import com.azure.containers.containerregistry.models.SetManifestOptions;
import com.azure.containers.containerregistry.models.SetManifestResult;
import com.azure.containers.containerregistry.models.UploadRegistryBlobResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRange;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.Tracer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.security.MessageDigest;
import java.util.Objects;
import java.util.function.Function;

@ServiceClient(builder=ContainerRegistryContentClientBuilder.class)
public final class ContainerRegistryContentClient {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerRegistryContentClient.class);
    private final ContainerRegistryBlobsImpl blobsImpl;
    private final ContainerRegistriesImpl registriesImpl;
    private final String endpoint;
    private final String repositoryName;
    private final Tracer tracer;

    ContainerRegistryContentClient(String repositoryName, HttpPipeline httpPipeline, String endpoint, String version, Tracer tracer) {
        this.repositoryName = repositoryName;
        this.endpoint = endpoint;
        AzureContainerRegistryImpl registryImplClient = new AzureContainerRegistryImpl(httpPipeline, endpoint, version);
        this.blobsImpl = registryImplClient.getContainerRegistryBlobs();
        this.registriesImpl = registryImplClient.getContainerRegistries();
        this.tracer = tracer;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SetManifestResult setManifest(OciImageManifest manifest, String tag) {
        Objects.requireNonNull(manifest, "'manifest' cannot be null.");
        return (SetManifestResult)this.setManifestWithResponse(BinaryData.fromObject((Object)manifest), tag, ManifestMediaType.OCI_IMAGE_MANIFEST, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SetManifestResult> setManifestWithResponse(SetManifestOptions options, Context context) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        return this.setManifestWithResponse(options.getManifest(), options.getTag(), options.getManifestMediaType(), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UploadRegistryBlobResult uploadBlob(BinaryData content) {
        return this.uploadBlob(content, Context.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ServiceMethod(returns=ReturnType.SINGLE)
    public UploadRegistryBlobResult uploadBlob(BinaryData content, Context context) {
        UploadRegistryBlobResult uploadRegistryBlobResult;
        Objects.requireNonNull(content, "'content' cannot be null.");
        InputStream stream = content.toStream();
        try {
            uploadRegistryBlobResult = this.runWithTracing("ContainerRegistryContentAsyncClient.uploadBlob", span -> this.uploadBlobInternal(stream, (Context)span), context);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOGGER.warning("Failed to close the stream", new Object[]{e});
            }
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            LOGGER.warning("Failed to close the stream", new Object[]{e});
        }
        return uploadRegistryBlobResult;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public GetManifestResult getManifest(String tagOrDigest) {
        return (GetManifestResult)this.getManifestWithResponse(tagOrDigest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GetManifestResult> getManifestWithResponse(String tagOrDigest, Context context) {
        Objects.requireNonNull(tagOrDigest, "'tagOrDigest' cannot be null.");
        try {
            Response<BinaryData> response = this.registriesImpl.getManifestWithResponse(this.repositoryName, tagOrDigest, UtilsImpl.SUPPORTED_MANIFEST_TYPES, context);
            return UtilsImpl.toGetManifestResponse(tagOrDigest, response);
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)UtilsImpl.mapAcrErrorsException(exception));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void downloadStream(String digest, WritableByteChannel channel) {
        this.downloadStream(digest, channel, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void downloadStream(String digest, WritableByteChannel channel, Context context) {
        this.runWithTracing("ContainerRegistryContentAsyncClient.downloadBlob", span -> this.downloadBlobInternal(digest, channel, (Context)span), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteBlob(String digest) {
        this.deleteBlobWithResponse(digest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteBlobWithResponse(String digest, Context context) {
        Objects.requireNonNull(digest, "'digest' cannot be null.");
        try {
            ResponseBase<ContainerRegistryBlobsDeleteBlobHeaders, Void> response = this.blobsImpl.deleteBlobWithResponse(this.repositoryName, digest, context);
            return UtilsImpl.deleteResponseToSuccess(response);
        }
        catch (HttpResponseException ex) {
            if (ex.getResponse().getStatusCode() == 404) {
                HttpResponse response = ex.getResponse();
                return new SimpleResponse(response.getRequest(), 202, response.getHeaders(), null);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteManifest(String digest) {
        this.deleteManifestWithResponse(digest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteManifestWithResponse(String digest, Context context) {
        try {
            Response<Void> response = this.registriesImpl.deleteManifestWithResponse(this.repositoryName, digest, context);
            return UtilsImpl.deleteResponseToSuccess(response);
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)UtilsImpl.mapAcrErrorsException(exception)));
        }
    }

    private UploadRegistryBlobResult uploadBlobInternal(InputStream stream, Context context) {
        MessageDigest sha256 = UtilsImpl.createSha256();
        byte[] buffer = new byte[0x400000];
        try {
            BinaryData chunk;
            ResponseBase<ContainerRegistryBlobsStartUploadHeaders, Void> startUploadResponse = this.blobsImpl.startUploadWithResponse(this.repositoryName, context);
            String location = UtilsImpl.getLocation(startUploadResponse);
            long streamLength = 0L;
            while ((chunk = this.readChunk(stream, sha256, buffer)) != null) {
                streamLength += chunk.getLength().longValue();
                if (chunk.getLength() < 0x400000L) break;
                ResponseBase<ContainerRegistryBlobsUploadChunkHeaders, Void> uploadChunkResponse = this.blobsImpl.uploadChunkWithResponse(location, chunk, chunk.getLength(), context);
                location = UtilsImpl.getLocation(uploadChunkResponse);
            }
            String digest = "sha256:" + CoreUtils.bytesToHexString((byte[])sha256.digest());
            ResponseBase<ContainerRegistryBlobsCompleteUploadHeaders, Void> completeUploadResponse = this.blobsImpl.completeUploadWithResponse(digest, location, chunk, chunk == null ? null : chunk.getLength(), context);
            return ConstructorAccessors.createUploadRegistryBlobResult(((ContainerRegistryBlobsCompleteUploadHeaders)completeUploadResponse.getDeserializedHeaders()).getDockerContentDigest(), streamLength);
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)UtilsImpl.mapAcrErrorsException(exception)));
        }
    }

    private BinaryData readChunk(InputStream stream, MessageDigest sha256, byte[] buffer) {
        int position;
        int read;
        for (position = 0; position < 0x400000; position += read) {
            try {
                read = stream.read(buffer, position, 0x400000 - position);
                if (read < 0) break;
                continue;
            }
            catch (IOException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
            }
        }
        if (position == 0) {
            return null;
        }
        sha256.update(buffer, 0, position);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        byteBuffer.limit(position);
        return BinaryData.fromByteBuffer((ByteBuffer)byteBuffer);
    }

    private Response<SetManifestResult> setManifestWithResponse(BinaryData manifestData, String tagOrDigest, ManifestMediaType manifestMediaType, Context context) {
        BinaryData data = manifestData.toReplayableBinaryData();
        if (tagOrDigest == null) {
            tagOrDigest = UtilsImpl.computeDigest(data.toByteBuffer());
        }
        try {
            ResponseBase<ContainerRegistriesCreateManifestHeaders, Void> response = this.registriesImpl.createManifestWithResponse(this.repositoryName, tagOrDigest, data, data.getLength(), manifestMediaType.toString(), context);
            return new ResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)ConstructorAccessors.createSetManifestResult(((ContainerRegistriesCreateManifestHeaders)response.getDeserializedHeaders()).getDockerContentDigest()), (Object)((ContainerRegistriesCreateManifestHeaders)response.getDeserializedHeaders()));
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)UtilsImpl.mapAcrErrorsException(exception)));
        }
    }

    private Context downloadBlobInternal(String digest, WritableByteChannel channel, Context context) {
        Objects.requireNonNull(digest, "'digest' cannot be null.");
        MessageDigest sha256 = UtilsImpl.createSha256();
        try {
            long length;
            HttpRange range = new HttpRange(0L, Long.valueOf(0x400000L));
            context = context.addData((Object)"azure-eagerly-read-response", (Object)true);
            ResponseBase<ContainerRegistryBlobsGetChunkHeaders, BinaryData> lastChunk = this.blobsImpl.getChunkWithResponse(this.repositoryName, digest, range.toString(), context);
            long blobSize = UtilsImpl.getBlobSize(lastChunk.getHeaders());
            for (long p = length = this.writeChunk((Response<BinaryData>)lastChunk, sha256, channel); p < blobSize; p += 0x400000L) {
                range = new HttpRange(p, Long.valueOf(0x400000L));
                lastChunk = this.blobsImpl.getChunkWithResponse(this.repositoryName, digest, range.toString(), context);
                this.writeChunk((Response<BinaryData>)lastChunk, sha256, channel);
            }
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)UtilsImpl.mapAcrErrorsException(exception)));
        }
        UtilsImpl.validateDigest(sha256, digest);
        return context;
    }

    private long writeChunk(Response<BinaryData> response, MessageDigest sha256, WritableByteChannel channel) {
        InputStream content = ((BinaryData)response.getValue()).toStream();
        ByteBuffer buffer = ByteBuffer.wrap(this.getBytes(content));
        sha256.update(buffer.asReadOnlyBuffer());
        try {
            channel.write(buffer);
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e) {
                throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
            }
        }
        return buffer.limit();
    }

    private byte[] getBytes(InputStream stream) {
        try {
            int nRead;
            ByteArrayOutputStream dataOutputBuffer = new ByteArrayOutputStream();
            byte[] data = new byte[8192];
            while ((nRead = stream.read(data, 0, data.length)) != -1) {
                dataOutputBuffer.write(data, 0, nRead);
            }
            return dataOutputBuffer.toByteArray();
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    private <T> T runWithTracing(String spanName, Function<Context, T> operation, Context context) {
        Context span = this.tracer.start(spanName, context);
        RuntimeException exception = null;
        try {
            T t = operation.apply(span);
            return t;
        }
        catch (RuntimeException ex) {
            exception = ex;
            throw ex;
        }
        finally {
            this.tracer.end(null, (Throwable)exception, span);
        }
    }
}

