/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry;

import com.azure.containers.containerregistry.ContainerRegistryClientBuilder;
import com.azure.containers.containerregistry.ContainerRepository;
import com.azure.containers.containerregistry.RegistryArtifact;
import com.azure.containers.containerregistry.implementation.AzureContainerRegistryImpl;
import com.azure.containers.containerregistry.implementation.ContainerRegistriesImpl;
import com.azure.containers.containerregistry.implementation.UtilsImpl;
import com.azure.containers.containerregistry.implementation.models.AcrErrorsException;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;

@ServiceClient(builder=ContainerRegistryClientBuilder.class)
public final class ContainerRegistryClient {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerRegistryClient.class);
    private final ContainerRegistriesImpl registriesImplClient;
    private final HttpPipeline httpPipeline;
    private final String endpoint;
    private final String apiVersion;

    ContainerRegistryClient(HttpPipeline httpPipeline, String endpoint, String version) {
        this.httpPipeline = httpPipeline;
        this.endpoint = endpoint;
        this.registriesImplClient = new AzureContainerRegistryImpl(httpPipeline, endpoint, version).getContainerRegistries();
        this.apiVersion = version;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRepositoryNames() {
        return this.listRepositoryNames(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRepositoryNames(Context context) {
        return new PagedIterable(pageSize -> this.listRepositoryNamesSinglePageSync((Integer)pageSize, context), (token, pageSize) -> this.listRepositoryNamesNextSinglePageSync((String)token, context));
    }

    private PagedResponse<String> listRepositoryNamesSinglePageSync(Integer pageSize, Context context) {
        if (pageSize != null && pageSize < 0) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'pageSize' cannot be negative."));
        }
        try {
            return this.registriesImplClient.getRepositoriesSinglePage(null, pageSize, context);
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)UtilsImpl.mapAcrErrorsException(exception)));
        }
    }

    private PagedResponse<String> listRepositoryNamesNextSinglePageSync(String nextLink, Context context) {
        try {
            return this.registriesImplClient.getRepositoriesNextSinglePage(nextLink, context);
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)UtilsImpl.mapAcrErrorsException(exception)));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteRepository(String repositoryName) {
        this.deleteRepositoryWithResponse(repositoryName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteRepositoryWithResponse(String repositoryName, Context context) {
        Objects.requireNonNull(repositoryName, "'repositoryName' cannot be null");
        if (repositoryName.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'repositoryName' cannot be empty."));
        }
        try {
            return UtilsImpl.deleteResponseToSuccess(this.registriesImplClient.deleteRepositoryWithResponse(repositoryName, context));
        }
        catch (AcrErrorsException exception) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)UtilsImpl.mapAcrErrorsException(exception)));
        }
    }

    public ContainerRepository getRepository(String repositoryName) {
        return new ContainerRepository(repositoryName, this.httpPipeline, this.endpoint, this.apiVersion);
    }

    public RegistryArtifact getArtifact(String repositoryName, String tagOrDigest) {
        return new RegistryArtifact(repositoryName, tagOrDigest, this.httpPipeline, this.endpoint, this.apiVersion);
    }
}

