/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation.models;

import com.azure.containers.containerregistry.implementation.models.FsLayer;
import com.azure.containers.containerregistry.implementation.models.History;
import com.azure.containers.containerregistry.implementation.models.ImageSignature;
import com.azure.containers.containerregistry.implementation.models.Manifest;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class V1Manifest
extends Manifest {
    private String architecture;
    private String name;
    private String tag;
    private List<FsLayer> fsLayers;
    private List<History> history;
    private List<ImageSignature> signatures;

    public String getArchitecture() {
        return this.architecture;
    }

    public V1Manifest setArchitecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public V1Manifest setName(String name) {
        this.name = name;
        return this;
    }

    public String getTag() {
        return this.tag;
    }

    public V1Manifest setTag(String tag) {
        this.tag = tag;
        return this;
    }

    public List<FsLayer> getFsLayers() {
        return this.fsLayers;
    }

    public V1Manifest setFsLayers(List<FsLayer> fsLayers) {
        this.fsLayers = fsLayers;
        return this;
    }

    public List<History> getHistory() {
        return this.history;
    }

    public V1Manifest setHistory(List<History> history) {
        this.history = history;
        return this;
    }

    public List<ImageSignature> getSignatures() {
        return this.signatures;
    }

    public V1Manifest setSignatures(List<ImageSignature> signatures) {
        this.signatures = signatures;
        return this;
    }

    @Override
    public V1Manifest setSchemaVersion(Integer schemaVersion) {
        super.setSchemaVersion(schemaVersion);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("schemaVersion", (Number)this.getSchemaVersion());
        jsonWriter.writeStringField("architecture", this.architecture);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("tag", this.tag);
        jsonWriter.writeArrayField("fsLayers", this.fsLayers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("history", this.history, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("signatures", this.signatures, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static V1Manifest fromJson(JsonReader jsonReader) throws IOException {
        return (V1Manifest)jsonReader.readObject(reader -> {
            V1Manifest deserializedV1Manifest = new V1Manifest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schemaVersion".equals(fieldName)) {
                    deserializedV1Manifest.setSchemaVersion((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("architecture".equals(fieldName)) {
                    deserializedV1Manifest.architecture = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedV1Manifest.name = reader.getString();
                    continue;
                }
                if ("tag".equals(fieldName)) {
                    deserializedV1Manifest.tag = reader.getString();
                    continue;
                }
                if ("fsLayers".equals(fieldName)) {
                    List fsLayers;
                    deserializedV1Manifest.fsLayers = fsLayers = reader.readArray(reader1 -> FsLayer.fromJson(reader1));
                    continue;
                }
                if ("history".equals(fieldName)) {
                    List history;
                    deserializedV1Manifest.history = history = reader.readArray(reader1 -> History.fromJson(reader1));
                    continue;
                }
                if ("signatures".equals(fieldName)) {
                    List signatures;
                    deserializedV1Manifest.signatures = signatures = reader.readArray(reader1 -> ImageSignature.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedV1Manifest;
        });
    }
}

