/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation.models;

import com.azure.containers.containerregistry.implementation.models.FsLayer;
import com.azure.containers.containerregistry.implementation.models.History;
import com.azure.containers.containerregistry.implementation.models.ImageSignature;
import com.azure.containers.containerregistry.implementation.models.Manifest;
import com.azure.containers.containerregistry.implementation.models.ManifestListAttributes;
import com.azure.containers.containerregistry.models.OciAnnotations;
import com.azure.containers.containerregistry.models.OciDescriptor;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ManifestWrapper
extends Manifest {
    private String mediaType;
    private List<ManifestListAttributes> manifests;
    private OciDescriptor config;
    private List<OciDescriptor> layers;
    private OciAnnotations annotations;
    private String architecture;
    private String name;
    private String tag;
    private List<FsLayer> fsLayers;
    private List<History> history;
    private List<ImageSignature> signatures;

    public String getMediaType() {
        return this.mediaType;
    }

    public ManifestWrapper setMediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public List<ManifestListAttributes> getManifests() {
        return this.manifests;
    }

    public ManifestWrapper setManifests(List<ManifestListAttributes> manifests) {
        this.manifests = manifests;
        return this;
    }

    public OciDescriptor getConfig() {
        return this.config;
    }

    public ManifestWrapper setConfig(OciDescriptor config) {
        this.config = config;
        return this;
    }

    public List<OciDescriptor> getLayers() {
        return this.layers;
    }

    public ManifestWrapper setLayers(List<OciDescriptor> layers) {
        this.layers = layers;
        return this;
    }

    public OciAnnotations getAnnotations() {
        return this.annotations;
    }

    public ManifestWrapper setAnnotations(OciAnnotations annotations) {
        this.annotations = annotations;
        return this;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public ManifestWrapper setArchitecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ManifestWrapper setName(String name) {
        this.name = name;
        return this;
    }

    public String getTag() {
        return this.tag;
    }

    public ManifestWrapper setTag(String tag) {
        this.tag = tag;
        return this;
    }

    public List<FsLayer> getFsLayers() {
        return this.fsLayers;
    }

    public ManifestWrapper setFsLayers(List<FsLayer> fsLayers) {
        this.fsLayers = fsLayers;
        return this;
    }

    public List<History> getHistory() {
        return this.history;
    }

    public ManifestWrapper setHistory(List<History> history) {
        this.history = history;
        return this;
    }

    public List<ImageSignature> getSignatures() {
        return this.signatures;
    }

    public ManifestWrapper setSignatures(List<ImageSignature> signatures) {
        this.signatures = signatures;
        return this;
    }

    @Override
    public ManifestWrapper setSchemaVersion(Integer schemaVersion) {
        super.setSchemaVersion(schemaVersion);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("schemaVersion", (Number)this.getSchemaVersion());
        jsonWriter.writeStringField("mediaType", this.mediaType);
        jsonWriter.writeArrayField("manifests", this.manifests, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("config", (JsonSerializable)this.config);
        jsonWriter.writeArrayField("layers", this.layers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("annotations", (JsonSerializable)this.annotations);
        jsonWriter.writeStringField("architecture", this.architecture);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("tag", this.tag);
        jsonWriter.writeArrayField("fsLayers", this.fsLayers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("history", this.history, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("signatures", this.signatures, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ManifestWrapper fromJson(JsonReader jsonReader) throws IOException {
        return (ManifestWrapper)jsonReader.readObject(reader -> {
            ManifestWrapper deserializedManifestWrapper = new ManifestWrapper();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schemaVersion".equals(fieldName)) {
                    deserializedManifestWrapper.setSchemaVersion((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("mediaType".equals(fieldName)) {
                    deserializedManifestWrapper.mediaType = reader.getString();
                    continue;
                }
                if ("manifests".equals(fieldName)) {
                    List manifests;
                    deserializedManifestWrapper.manifests = manifests = reader.readArray(reader1 -> ManifestListAttributes.fromJson(reader1));
                    continue;
                }
                if ("config".equals(fieldName)) {
                    deserializedManifestWrapper.config = OciDescriptor.fromJson(reader);
                    continue;
                }
                if ("layers".equals(fieldName)) {
                    List layers;
                    deserializedManifestWrapper.layers = layers = reader.readArray(reader1 -> OciDescriptor.fromJson(reader1));
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    deserializedManifestWrapper.annotations = OciAnnotations.fromJson(reader);
                    continue;
                }
                if ("architecture".equals(fieldName)) {
                    deserializedManifestWrapper.architecture = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManifestWrapper.name = reader.getString();
                    continue;
                }
                if ("tag".equals(fieldName)) {
                    deserializedManifestWrapper.tag = reader.getString();
                    continue;
                }
                if ("fsLayers".equals(fieldName)) {
                    List fsLayers;
                    deserializedManifestWrapper.fsLayers = fsLayers = reader.readArray(reader1 -> FsLayer.fromJson(reader1));
                    continue;
                }
                if ("history".equals(fieldName)) {
                    List history;
                    deserializedManifestWrapper.history = history = reader.readArray(reader1 -> History.fromJson(reader1));
                    continue;
                }
                if ("signatures".equals(fieldName)) {
                    List signatures;
                    deserializedManifestWrapper.signatures = signatures = reader.readArray(reader1 -> ImageSignature.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManifestWrapper;
        });
    }
}

