/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation.authentication;

import com.azure.containers.containerregistry.implementation.AuthenticationsImpl;
import com.azure.containers.containerregistry.implementation.authentication.ContainerRegistryTokenRequestContext;
import com.azure.containers.containerregistry.implementation.authentication.JsonWebToken;
import com.azure.containers.containerregistry.implementation.models.AcrRefreshToken;
import com.azure.containers.containerregistry.implementation.models.PostContentSchemaGrantType;
import com.azure.containers.containerregistry.models.ContainerRegistryAudience;
import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.exception.ServiceResponseException;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import reactor.core.publisher.Mono;

public class ContainerRegistryRefreshTokenCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerRegistryRefreshTokenCredential.class);
    private final TokenCredential aadTokenCredential;
    private final AuthenticationsImpl authenticationsImpl;
    private final TokenRequestContext tokenRequestContext;

    ContainerRegistryRefreshTokenCredential(AuthenticationsImpl authenticationsImpl, TokenCredential aadTokenCredential, ContainerRegistryAudience audience) {
        this.authenticationsImpl = authenticationsImpl;
        this.aadTokenCredential = aadTokenCredential;
        this.tokenRequestContext = new TokenRequestContext().addScopes(new String[]{(Object)((Object)audience) + "/.default"});
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        if (!(request instanceof ContainerRegistryTokenRequestContext)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("Unexpected request type - " + request.getClass().getName()));
        }
        ContainerRegistryTokenRequestContext crRequest = (ContainerRegistryTokenRequestContext)request;
        return this.aadTokenCredential.getToken(this.tokenRequestContext).flatMap(token -> this.authenticationsImpl.exchangeAadAccessTokenForAcrRefreshTokenWithResponseAsync(PostContentSchemaGrantType.ACCESS_TOKEN, crRequest.getServiceName(), null, null, token.getToken(), Context.NONE)).map(this::toAccessToken);
    }

    public AccessToken getTokenSync(TokenRequestContext request) {
        if (!(request instanceof ContainerRegistryTokenRequestContext)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unexpected request type - " + request.getClass().getName()));
        }
        ContainerRegistryTokenRequestContext crRequest = (ContainerRegistryTokenRequestContext)request;
        AccessToken token = this.aadTokenCredential.getTokenSync(this.tokenRequestContext);
        Response<AcrRefreshToken> acrRefreshToken = this.authenticationsImpl.exchangeAadAccessTokenForAcrRefreshTokenWithResponse(PostContentSchemaGrantType.ACCESS_TOKEN, crRequest.getServiceName(), null, null, token.getToken(), Context.NONE);
        return this.toAccessToken(acrRefreshToken);
    }

    private AccessToken toAccessToken(Response<AcrRefreshToken> response) {
        AcrRefreshToken token = (AcrRefreshToken)response.getValue();
        if (token != null) {
            String accessToken = token.getRefreshToken();
            return new AccessToken(accessToken, JsonWebToken.retrieveExpiration(accessToken));
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new ServiceResponseException("AcrRefreshToken is missing in response"));
    }
}

