/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry;

import com.azure.containers.containerregistry.ContainerRegistryContentAsyncClient;
import com.azure.containers.containerregistry.ContainerRegistryContentClient;
import com.azure.containers.containerregistry.ContainerRegistryServiceVersion;
import com.azure.containers.containerregistry.implementation.UtilsImpl;
import com.azure.containers.containerregistry.models.ContainerRegistryAudience;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.Tracer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={ContainerRegistryContentAsyncClient.class, ContainerRegistryContentClient.class})
public final class ContainerRegistryContentClientBuilder
implements ConfigurationTrait<ContainerRegistryContentClientBuilder>,
EndpointTrait<ContainerRegistryContentClientBuilder>,
HttpTrait<ContainerRegistryContentClientBuilder>,
TokenCredentialTrait<ContainerRegistryContentClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerRegistryContentClientBuilder.class);
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private ClientOptions clientOptions;
    private Configuration configuration;
    private String endpoint;
    private HttpClient httpClient;
    private TokenCredential credential;
    private HttpPipeline httpPipeline;
    private HttpLogOptions httpLogOptions;
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;
    private ContainerRegistryServiceVersion version;
    private ContainerRegistryAudience audience;
    private String repositoryName;

    public ContainerRegistryContentClientBuilder endpoint(String endpoint) {
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL", ex));
        }
        this.endpoint = endpoint;
        return this;
    }

    public ContainerRegistryContentClientBuilder repositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
        return this;
    }

    public ContainerRegistryContentClientBuilder audience(ContainerRegistryAudience audience) {
        this.audience = audience;
        return this;
    }

    public ContainerRegistryContentClientBuilder credential(TokenCredential credential) {
        this.credential = credential;
        return this;
    }

    public ContainerRegistryContentClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            LOGGER.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public ContainerRegistryContentClientBuilder serviceVersion(ContainerRegistryServiceVersion version) {
        this.version = version;
        return this;
    }

    public ContainerRegistryContentClientBuilder httpClient(HttpClient httpClient) {
        if (this.httpClient != null && httpClient == null) {
            LOGGER.info("HttpClient is being set to 'null' when it was previously configured.");
        }
        this.httpClient = httpClient;
        return this;
    }

    public ContainerRegistryContentClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public ContainerRegistryContentClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ContainerRegistryContentClientBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public ContainerRegistryContentClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public ContainerRegistryContentClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public ContainerRegistryContentClientBuilder addPolicy(HttpPipelinePolicy policy) {
        Objects.requireNonNull(policy, "'policy' cannot be null.");
        if (policy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(policy);
        } else {
            this.perRetryPolicies.add(policy);
        }
        return this;
    }

    public ContainerRegistryContentAsyncClient buildAsyncClient() {
        Objects.requireNonNull(this.endpoint, "'endpoint' can't be null");
        ContainerRegistryServiceVersion serviceVersion = this.version != null ? this.version : ContainerRegistryServiceVersion.getLatest();
        Tracer tracer = UtilsImpl.createTracer(this.clientOptions);
        HttpPipeline pipeline = this.getHttpPipeline(tracer);
        ContainerRegistryContentAsyncClient client = new ContainerRegistryContentAsyncClient(this.repositoryName, pipeline, this.endpoint, serviceVersion.getVersion(), tracer);
        return client;
    }

    public ContainerRegistryContentClient buildClient() {
        Objects.requireNonNull(this.endpoint, "'endpoint' can't be null");
        ContainerRegistryServiceVersion serviceVersion = this.version != null ? this.version : ContainerRegistryServiceVersion.getLatest();
        Tracer tracer = UtilsImpl.createTracer(this.clientOptions);
        return new ContainerRegistryContentClient(this.repositoryName, this.getHttpPipeline(tracer), this.endpoint, serviceVersion.getVersion(), tracer);
    }

    private HttpPipeline getHttpPipeline(Tracer tracer) {
        if (this.httpPipeline != null) {
            return this.httpPipeline;
        }
        return UtilsImpl.buildClientPipeline(this.clientOptions, this.httpLogOptions, this.configuration, this.retryPolicy, this.retryOptions, this.credential, this.audience, this.perCallPolicies, this.perRetryPolicies, this.httpClient, this.endpoint, this.version, tracer);
    }
}

