/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Objects;

public class TagAttributesBase
implements JsonSerializable<TagAttributesBase> {
    private String name;
    private String digest;
    private OffsetDateTime createdOn;
    private OffsetDateTime lastUpdatedOn;
    private Boolean deleteEnabled;
    private Boolean writeEnabled;
    private Boolean listEnabled;
    private Boolean readEnabled;

    public String getName() {
        return this.name;
    }

    public TagAttributesBase setName(String name) {
        this.name = name;
        return this;
    }

    public String getDigest() {
        return this.digest;
    }

    public TagAttributesBase setDigest(String digest) {
        this.digest = digest;
        return this;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public TagAttributesBase setCreatedOn(OffsetDateTime createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    public OffsetDateTime getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public TagAttributesBase setLastUpdatedOn(OffsetDateTime lastUpdatedOn) {
        this.lastUpdatedOn = lastUpdatedOn;
        return this;
    }

    public Boolean isDeleteEnabled() {
        return this.deleteEnabled;
    }

    public TagAttributesBase setDeleteEnabled(Boolean deleteEnabled) {
        this.deleteEnabled = deleteEnabled;
        return this;
    }

    public Boolean isWriteEnabled() {
        return this.writeEnabled;
    }

    public TagAttributesBase setWriteEnabled(Boolean writeEnabled) {
        this.writeEnabled = writeEnabled;
        return this;
    }

    public Boolean isListEnabled() {
        return this.listEnabled;
    }

    public TagAttributesBase setListEnabled(Boolean listEnabled) {
        this.listEnabled = listEnabled;
        return this;
    }

    public Boolean isReadEnabled() {
        return this.readEnabled;
    }

    public TagAttributesBase setReadEnabled(Boolean readEnabled) {
        this.readEnabled = readEnabled;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("digest", this.digest);
        jsonWriter.writeStringField("createdTime", Objects.toString(this.createdOn, null));
        jsonWriter.writeStringField("lastUpdateTime", Objects.toString(this.lastUpdatedOn, null));
        if (this.deleteEnabled != null || this.writeEnabled != null || this.listEnabled != null || this.readEnabled != null) {
            jsonWriter.writeStartObject("changeableAttributes");
            jsonWriter.writeBooleanField("deleteEnabled", this.deleteEnabled);
            jsonWriter.writeBooleanField("writeEnabled", this.writeEnabled);
            jsonWriter.writeBooleanField("listEnabled", this.listEnabled);
            jsonWriter.writeBooleanField("readEnabled", this.readEnabled);
            jsonWriter.writeEndObject();
        }
        return jsonWriter.writeEndObject();
    }

    public static TagAttributesBase fromJson(JsonReader jsonReader) throws IOException {
        return (TagAttributesBase)jsonReader.readObject(reader -> {
            TagAttributesBase deserializedTagAttributesBase = new TagAttributesBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedTagAttributesBase.name = reader.getString();
                    continue;
                }
                if ("digest".equals(fieldName)) {
                    deserializedTagAttributesBase.digest = reader.getString();
                    continue;
                }
                if ("createdTime".equals(fieldName)) {
                    deserializedTagAttributesBase.createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdateTime".equals(fieldName)) {
                    deserializedTagAttributesBase.lastUpdatedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("changeableAttributes".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("deleteEnabled".equals(fieldName)) {
                            deserializedTagAttributesBase.deleteEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("writeEnabled".equals(fieldName)) {
                            deserializedTagAttributesBase.writeEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("listEnabled".equals(fieldName)) {
                            deserializedTagAttributesBase.listEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("readEnabled".equals(fieldName)) {
                            deserializedTagAttributesBase.readEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTagAttributesBase;
        });
    }
}

