/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Objects;

public class ArtifactTagPropertiesInternal
implements JsonSerializable<ArtifactTagPropertiesInternal> {
    private String registryLoginServer;
    private String repositoryName;
    private String name;
    private String digest;
    private OffsetDateTime createdOn;
    private OffsetDateTime lastUpdatedOn;
    private Boolean deleteEnabled;
    private Boolean writeEnabled;
    private Boolean listEnabled;
    private Boolean readEnabled;

    public String getRegistryLoginServer() {
        return this.registryLoginServer;
    }

    public ArtifactTagPropertiesInternal setRegistryLoginServer(String registryLoginServer) {
        this.registryLoginServer = registryLoginServer;
        return this;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public ArtifactTagPropertiesInternal setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ArtifactTagPropertiesInternal setName(String name) {
        this.name = name;
        return this;
    }

    public String getDigest() {
        return this.digest;
    }

    public ArtifactTagPropertiesInternal setDigest(String digest) {
        this.digest = digest;
        return this;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public ArtifactTagPropertiesInternal setCreatedOn(OffsetDateTime createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    public OffsetDateTime getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public ArtifactTagPropertiesInternal setLastUpdatedOn(OffsetDateTime lastUpdatedOn) {
        this.lastUpdatedOn = lastUpdatedOn;
        return this;
    }

    public Boolean isDeleteEnabled() {
        return this.deleteEnabled;
    }

    public ArtifactTagPropertiesInternal setDeleteEnabled(Boolean deleteEnabled) {
        this.deleteEnabled = deleteEnabled;
        return this;
    }

    public Boolean isWriteEnabled() {
        return this.writeEnabled;
    }

    public ArtifactTagPropertiesInternal setWriteEnabled(Boolean writeEnabled) {
        this.writeEnabled = writeEnabled;
        return this;
    }

    public Boolean isListEnabled() {
        return this.listEnabled;
    }

    public ArtifactTagPropertiesInternal setListEnabled(Boolean listEnabled) {
        this.listEnabled = listEnabled;
        return this;
    }

    public Boolean isReadEnabled() {
        return this.readEnabled;
    }

    public ArtifactTagPropertiesInternal setReadEnabled(Boolean readEnabled) {
        this.readEnabled = readEnabled;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("registry", this.registryLoginServer);
        jsonWriter.writeStringField("imageName", this.repositoryName);
        if (this.name != null || this.digest != null || this.createdOn != null || this.lastUpdatedOn != null || this.deleteEnabled != null || this.writeEnabled != null || this.listEnabled != null || this.readEnabled != null) {
            jsonWriter.writeStartObject("tag");
            jsonWriter.writeStringField("name", this.name);
            jsonWriter.writeStringField("digest", this.digest);
            jsonWriter.writeStringField("createdTime", Objects.toString(this.createdOn, null));
            jsonWriter.writeStringField("lastUpdateTime", Objects.toString(this.lastUpdatedOn, null));
            if (this.deleteEnabled != null || this.writeEnabled != null || this.listEnabled != null || this.readEnabled != null) {
                jsonWriter.writeStartObject("changeableAttributes");
                jsonWriter.writeBooleanField("deleteEnabled", this.deleteEnabled);
                jsonWriter.writeBooleanField("writeEnabled", this.writeEnabled);
                jsonWriter.writeBooleanField("listEnabled", this.listEnabled);
                jsonWriter.writeBooleanField("readEnabled", this.readEnabled);
                jsonWriter.writeEndObject();
            }
            jsonWriter.writeEndObject();
        }
        return jsonWriter.writeEndObject();
    }

    public static ArtifactTagPropertiesInternal fromJson(JsonReader jsonReader) throws IOException {
        return (ArtifactTagPropertiesInternal)jsonReader.readObject(reader -> {
            ArtifactTagPropertiesInternal deserializedArtifactTagPropertiesInternal = new ArtifactTagPropertiesInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("registry".equals(fieldName)) {
                    deserializedArtifactTagPropertiesInternal.registryLoginServer = reader.getString();
                    continue;
                }
                if ("imageName".equals(fieldName)) {
                    deserializedArtifactTagPropertiesInternal.repositoryName = reader.getString();
                    continue;
                }
                if ("tag".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("name".equals(fieldName)) {
                            deserializedArtifactTagPropertiesInternal.name = reader.getString();
                            continue;
                        }
                        if ("digest".equals(fieldName)) {
                            deserializedArtifactTagPropertiesInternal.digest = reader.getString();
                            continue;
                        }
                        if ("createdTime".equals(fieldName)) {
                            deserializedArtifactTagPropertiesInternal.createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                            continue;
                        }
                        if ("lastUpdateTime".equals(fieldName)) {
                            deserializedArtifactTagPropertiesInternal.lastUpdatedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                            continue;
                        }
                        if ("changeableAttributes".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                            while (reader.nextToken() != JsonToken.END_OBJECT) {
                                fieldName = reader.getFieldName();
                                reader.nextToken();
                                if ("deleteEnabled".equals(fieldName)) {
                                    deserializedArtifactTagPropertiesInternal.deleteEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                                    continue;
                                }
                                if ("writeEnabled".equals(fieldName)) {
                                    deserializedArtifactTagPropertiesInternal.writeEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                                    continue;
                                }
                                if ("listEnabled".equals(fieldName)) {
                                    deserializedArtifactTagPropertiesInternal.listEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                                    continue;
                                }
                                if ("readEnabled".equals(fieldName)) {
                                    deserializedArtifactTagPropertiesInternal.readEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                                    continue;
                                }
                                reader.skipChildren();
                            }
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedArtifactTagPropertiesInternal;
        });
    }
}

